/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.SimpleBroadcaster;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketHandler;

public interface WebSocketProcessor {
    public boolean handshake(HttpServletRequest var1);

    public WebSocketProcessor registerWebSocketHandler(String var1, WebSocketHandlerProxy var2);

    public void open(WebSocket var1, AtmosphereRequest var2, AtmosphereResponse var3) throws IOException;

    public void invokeWebSocketProtocol(WebSocket var1, String var2);

    public void invokeWebSocketProtocol(WebSocket var1, byte[] var2, int var3, int var4);

    public void invokeWebSocketProtocol(WebSocket var1, InputStream var2);

    public void invokeWebSocketProtocol(WebSocket var1, Reader var2) throws IOException;

    public void close(WebSocket var1, int var2);

    public void notifyListener(WebSocket var1, WebSocketEventListener.WebSocketEvent var2);

    public void destroy();

    public static final class WebSocketHandlerProxy
    implements WebSocketHandler {
        final Class<? extends Broadcaster> broadcasterClazz;
        final WebSocketHandler proxied;
        private String path;
        private final List<AtmosphereInterceptor> interceptors;

        public WebSocketHandlerProxy(Class<? extends Broadcaster> broadcasterClazz, WebSocketHandler proxied, List<AtmosphereInterceptor> interceptors) {
            this.broadcasterClazz = broadcasterClazz;
            this.proxied = proxied;
            this.interceptors = interceptors;
        }

        public WebSocketHandlerProxy(WebSocketHandler proxied) {
            this.broadcasterClazz = SimpleBroadcaster.class;
            this.proxied = proxied;
            this.interceptors = Collections.emptyList();
        }

        public String path() {
            return this.path;
        }

        public WebSocketHandlerProxy path(String path) {
            this.path = path;
            return this;
        }

        public WebSocketHandler proxied() {
            return this.proxied;
        }

        public List<AtmosphereInterceptor> interceptors() {
            return this.interceptors;
        }

        @Override
        public void onByteMessage(WebSocket webSocket, byte[] data, int offset, int length) throws IOException {
            this.proxied.onByteMessage(webSocket, data, offset, length);
        }

        @Override
        public void onTextMessage(WebSocket webSocket, String data) throws IOException {
            this.proxied.onTextMessage(webSocket, data);
        }

        @Override
        public void onOpen(WebSocket webSocket) throws IOException {
            this.proxied.onOpen(webSocket);
        }

        @Override
        public void onClose(WebSocket webSocket) {
            this.proxied.onClose(webSocket);
        }

        @Override
        public void onError(WebSocket webSocket, WebSocketException t) {
            this.proxied.onError(webSocket, t);
        }
    }

    public static final class WebSocketException
    extends Exception {
        private final AtmosphereResponse r;

        public WebSocketException(String s, AtmosphereResponse r) {
            super(s);
            this.r = r;
        }

        public WebSocketException(Throwable throwable, AtmosphereResponse r) {
            super(throwable);
            this.r = r;
        }

        public AtmosphereResponse response() {
            return this.r;
        }
    }
}

