/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.webapp;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.richfaces.application.push.impl.PushContextFactoryImpl;
import org.richfaces.webapp.PushHandlerFilter;
import org.richfaces.webapp.ServletConfigDefaultsFacade;

public final class PushServlet
extends AtmosphereServlet {
    private static final long serialVersionUID = 2483746935231439236L;
    private static final Map<String, String> DEFAULT_INIT_PARAMETERS = Maps.newHashMap();
    private boolean initialized = false;
    private boolean destroyed = false;

    public void init(ServletConfig sc) throws ServletException {
        if (!this.initialized) {
            super.init((ServletConfig)new ServletConfigDefaultsFacade(sc, DEFAULT_INIT_PARAMETERS));
            this.initialized = true;
            String mapping = (String)sc.getServletContext().getAttribute(PushContextFactoryImpl.PUSH_HANDLER_MAPPING_ATTRIBUTE);
            if (mapping == null) {
                mapping = "*";
            }
            ReflectorServletProcessor r = new ReflectorServletProcessor((Servlet)this);
            r.setFilterClassName(PushHandlerFilter.class.getName());
            this.framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r).initAtmosphereHandler(sc);
        }
    }

    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            super.destroy();
        }
    }

    static {
        DEFAULT_INIT_PARAMETERS.put("org.atmosphere.disableOnStateEvent", "true");
    }
}

