/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.RichFacesAdvancedInlineCalendar;
import org.richfaces.fragment.calendar.YearAndMonthEditor;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class HeaderControls {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindByJQuery(value=".rf-cal-tl:eq(0) > div")
    private GrapheneElement previousYearElement;
    @FindByJQuery(value=".rf-cal-tl:eq(1) > div")
    private GrapheneElement previousMonthElement;
    @FindBy(css=".rf-cal-hdr-month > div")
    private GrapheneElement yearAndMonthEditorOpenerElement;
    @FindByJQuery(value=".rf-cal-tl:eq(2) > div")
    private GrapheneElement nextMonthElement;
    @FindByJQuery(value=".rf-cal-tl:eq(3) > div")
    private GrapheneElement nextYearElement;
    private RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor;
    private final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"MMMM, yyyy");
    private long _timeoutForPopupToBeNotVisible = -1L;

    private void _openYearAndMonthEditor() {
        if (!this.isVisible() || !this.getYearAndMonthEditorOpenerElement().isDisplayed()) {
            throw new RuntimeException("Cannot open date editor. Ensure that calendar popup and header controls are displayed and some date is set.");
        }
        this.getYearAndMonthEditorOpenerElement().click();
        this.calendarEditor.getDateEditor().waitUntilIsVisible().perform();
    }

    public WebElement getNextMonthElement() {
        return this.nextMonthElement;
    }

    public WebElement getNextYearElement() {
        return this.nextYearElement;
    }

    public WebElement getPreviousMonthElement() {
        return this.previousMonthElement;
    }

    public WebElement getPreviousYearElement() {
        return this.previousYearElement;
    }

    public DateTime getYearAndMonth() {
        return this.getFormatter().parseDateTime(this.getYearAndMonthEditorOpenerElement().getText());
    }

    public YearAndMonthEditor getYearAndMonthEditor() {
        return this.calendarEditor.getDateEditor();
    }

    public WebElement getYearAndMonthEditorOpenerElement() {
        return this.yearAndMonthEditorOpenerElement;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRoot());
    }

    public void nextMonth() {
        if (!this.isVisible() || !this.getNextMonthElement().isDisplayed()) {
            throw new RuntimeException("Cannot interact with nextMonth button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.getYearAndMonthEditorOpenerElement().getText();
        this.getNextMonthElement().click();
        ((StringMatcher)Graphene.waitAjax().until().element(this.getYearAndMonthEditorOpenerElement()).text().not()).equalTo(before);
    }

    public void nextYear() {
        if (!this.isVisible() || !this.getNextYearElement().isDisplayed()) {
            throw new RuntimeException("Cannot interact with nextYear button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.getYearAndMonthEditorOpenerElement().getText();
        this.getNextYearElement().click();
        ((StringMatcher)Graphene.waitAjax().until().element(this.getYearAndMonthEditorOpenerElement()).text().not()).equalTo(before);
    }

    public YearAndMonthEditor openYearAndMonthEditor() {
        if (Utils.isVisible(this.calendarEditor.getDateEditor().getRootElement())) {
            return this.calendarEditor.getDateEditor();
        }
        this._openYearAndMonthEditor();
        return this.calendarEditor.getDateEditor();
    }

    public void previousYear() {
        if (!this.isVisible() || !this.getPreviousYearElement().isDisplayed()) {
            throw new RuntimeException("Cannot interact with previousYear button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.getYearAndMonthEditorOpenerElement().getText();
        this.getPreviousYearElement().click();
        ((StringMatcher)Graphene.waitAjax().until().element(this.getYearAndMonthEditorOpenerElement()).text().not()).equalTo(before);
    }

    public void previousMonth() {
        if (!this.isVisible() || !this.getPreviousMonthElement().isDisplayed()) {
            throw new RuntimeException("Cannot interact with previousMonth button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.getYearAndMonthEditorOpenerElement().getText();
        this.getPreviousMonthElement().click();
        ((StringMatcher)Graphene.waitAjax().until().element(this.getYearAndMonthEditorOpenerElement()).text().not()).equalTo(before);
    }

    public void setCalendarEditor(RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor) {
        this.calendarEditor = calendarEditor;
    }

    public void setTimeoutForPopupToBeNotVisible(long timeoutInMilliseconds) {
        this._timeoutForPopupToBeNotVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForPopupToBeNotVisible() {
        return this._timeoutForPopupToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForPopupToBeNotVisible;
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(HeaderControls.this.getRoot()).is().not()).visible();
            }
        }.withMessage("Header controls to be not visible.").withTimeout(this.getTimeoutForPopupToBeNotVisible(), TimeUnit.MILLISECONDS);
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(HeaderControls.this.getRoot()).is().visible();
            }
        }.withMessage("Header controls to be visible.");
    }

    public WebElement getRoot() {
        return this.root;
    }

    protected DateTimeFormatter getFormatter() {
        return this.formatter;
    }
}

