/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common.picker;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;

public final class ChoicePickerHelper {
    private ChoicePickerHelper() {
    }

    public static ByIndexChoicePicker byIndex() {
        return new ByIndexChoicePicker();
    }

    public static ByVisibleTextChoicePicker byVisibleText() {
        return new ByVisibleTextChoicePicker();
    }

    public static WebElementPicking.WebElementPicker byWebElement() {
        return new WebElementPickerImpl();
    }

    public static class WebElementPickerImpl
    implements WebElementPicking.WebElementPicker {
        private final LinkedList<MergingPredicate> predicates = new LinkedList();
        private final LinkedList<LogicalFunctions> logicalFunctions = new LinkedList();
        private final WebElementPicking.ComparationBy comparation = new ComparationByImpl();
        private final WebElementPicking.LogicalOperation operation = new LogicalOperationImpl();
        private final WebElementPicking.CanBeNegated canBeNegated = new CanBeNegatedImpl();
        private Function<WebElement, WebElement> transformationFunction;
        private Function<WebElement, String> webElementFunction;

        @Override
        public WebElementPicking.ComparationBy attribute(String attributeName) {
            this.webElementFunction = new GetAttributeFunction(attributeName);
            return this.comparation;
        }

        @Override
        public WebElement pick(List<WebElement> options) {
            List<WebElement> elements = this.pickInner(options, Boolean.TRUE);
            return elements.isEmpty() ? null : elements.get(0);
        }

        private List<WebElement> pickInner(List<WebElement> options, boolean pickFirst) {
            Preconditions.checkNotNull(options, (Object)"Options cannot be null.");
            Preconditions.checkArgument((!this.predicates.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((this.predicates.size() - 1 == this.logicalFunctions.size() ? 1 : 0) != 0);
            if (options.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            try {
                LinkedHashSet result;
                if (pickFirst) {
                    result = Sets.newLinkedHashSet();
                    result.add(Iterables.find(options, (Predicate)new FinalPredicate()));
                } else {
                    result = Sets.newLinkedHashSet((Iterable)Iterables.filter(options, (Predicate)new FinalPredicate()));
                }
                return Lists.newArrayList((Iterable)result);
            }
            catch (NoSuchElementException ex) {
                return Collections.EMPTY_LIST;
            }
        }

        @Override
        public List<WebElement> pickMultiple(List<WebElement> options) {
            return this.pickInner(options, Boolean.FALSE);
        }

        @Override
        public WebElementPicking.ComparationBy text() {
            this.webElementFunction = new GetTextFunction();
            return this.comparation;
        }

        private WebElement transFormIfNeeded(WebElement input) {
            return this.transformationFunction == null ? input : (WebElement)this.transformationFunction.apply((Object)input);
        }

        private static abstract class CompareToFunction
        implements Function<String, Boolean> {
            private final String compareTo;

            public CompareToFunction(String compareTo) {
                this.compareTo = compareTo;
            }

            public String getCompareTo() {
                return this.compareTo;
            }

            public String toString() {
                return this.getClass().getSimpleName() + '{' + this.compareTo + '}';
            }
        }

        private static class StartsWithFunction
        extends CompareToFunction {
            public StartsWithFunction(String compareTo) {
                super(compareTo);
            }

            public Boolean apply(String input) {
                return input.startsWith(this.getCompareTo());
            }
        }

        private static class MatchesFunction
        extends CompareToFunction {
            public MatchesFunction(String compareTo) {
                super(compareTo);
            }

            public Boolean apply(String input) {
                return input.matches(this.getCompareTo());
            }
        }

        private static class EqualsToFunction
        extends CompareToFunction {
            public EqualsToFunction(String compareTo) {
                super(compareTo);
            }

            public Boolean apply(String input) {
                return input.equals(this.getCompareTo());
            }
        }

        private static class EndsWithFunction
        extends CompareToFunction {
            public EndsWithFunction(String compareTo) {
                super(compareTo);
            }

            public Boolean apply(String input) {
                return input.endsWith(this.getCompareTo());
            }
        }

        private static class ContainsFunction
        extends CompareToFunction {
            public ContainsFunction(String compareTo) {
                super(compareTo);
            }

            public Boolean apply(String input) {
                return input.contains(this.getCompareTo());
            }
        }

        private static class GetAttributeFunction
        implements Function<WebElement, String> {
            private final String attName;

            public GetAttributeFunction(String attName) {
                this.attName = attName;
            }

            public String apply(WebElement input) {
                return input.getAttribute(this.attName);
            }

            public String toString() {
                return "GetAttributeFunction{attName=" + this.attName + '}';
            }
        }

        private class GetTextFunction
        implements Function<WebElement, String> {
            private GetTextFunction() {
            }

            public String apply(WebElement input) {
                return input.getText();
            }

            public String toString() {
                return "GetTextFunction()";
            }
        }

        private static class MergingPredicate
        implements Predicate<WebElement> {
            private final Function<WebElement, String> elementToString;
            private final Function<String, Boolean> stringToBoolean;
            private boolean negate = Boolean.FALSE;

            public MergingPredicate(Function<WebElement, String> elementToString, Function<String, Boolean> stringToBoolean) {
                this.elementToString = elementToString;
                this.stringToBoolean = stringToBoolean;
            }

            public void negate() {
                this.negate = Boolean.TRUE;
            }

            public boolean apply(WebElement input) {
                boolean result = (Boolean)this.stringToBoolean.apply(this.elementToString.apply((Object)input));
                return this.negate ? !result : result;
            }

            public String toString() {
                return "MergingPredicate{elementToString=" + this.elementToString + ", stringToBoolean=" + this.stringToBoolean + ", negate=" + this.negate + '}';
            }
        }

        private class CanBeNegatedImpl
        extends LogicalOperationImpl
        implements WebElementPicking.CanBeNegated {
            private CanBeNegatedImpl() {
            }

            @Override
            public WebElementPicking.LogicalOperation not() {
                ((MergingPredicate)WebElementPickerImpl.this.predicates.peekLast()).negate();
                return WebElementPickerImpl.this.operation;
            }
        }

        private class LogicalOperationImpl
        implements WebElementPicking.LogicalOperation {
            private LogicalOperationImpl() {
            }

            @Override
            public WebElementPicking and() {
                WebElementPickerImpl.this.logicalFunctions.add(LogicalFunctions.AND);
                return WebElementPickerImpl.this;
            }

            @Override
            public WebElementPicking or() {
                WebElementPickerImpl.this.logicalFunctions.add(LogicalFunctions.OR);
                return WebElementPickerImpl.this;
            }

            @Override
            public WebElement pick(List<WebElement> options) {
                return WebElementPickerImpl.this.pick(options);
            }

            @Override
            public List<WebElement> pickMultiple(List<WebElement> options) {
                return WebElementPickerImpl.this.pickMultiple(options);
            }
        }

        private class ComparationByImpl
        implements WebElementPicking.ComparationBy {
            private ComparationByImpl() {
            }

            @Override
            public WebElementPicking.CanBeNegated contains(String str) {
                WebElementPickerImpl.this.predicates.add(new MergingPredicate((Function<WebElement, String>)WebElementPickerImpl.this.webElementFunction, new ContainsFunction(str)));
                return WebElementPickerImpl.this.canBeNegated;
            }

            @Override
            public WebElementPicking.CanBeNegated endsWith(String str) {
                WebElementPickerImpl.this.predicates.add(new MergingPredicate((Function<WebElement, String>)WebElementPickerImpl.this.webElementFunction, new EndsWithFunction(str)));
                return WebElementPickerImpl.this.canBeNegated;
            }

            @Override
            public WebElementPicking.CanBeNegated equalTo(String str) {
                WebElementPickerImpl.this.predicates.add(new MergingPredicate((Function<WebElement, String>)WebElementPickerImpl.this.webElementFunction, new EqualsToFunction(str)));
                return WebElementPickerImpl.this.canBeNegated;
            }

            @Override
            public WebElementPicking.CanBeNegated matches(String str) {
                WebElementPickerImpl.this.predicates.add(new MergingPredicate((Function<WebElement, String>)WebElementPickerImpl.this.webElementFunction, new MatchesFunction(str)));
                return WebElementPickerImpl.this.canBeNegated;
            }

            @Override
            public WebElementPicking.CanBeNegated starstWith(String str) {
                WebElementPickerImpl.this.predicates.add(new MergingPredicate((Function<WebElement, String>)WebElementPickerImpl.this.webElementFunction, new StartsWithFunction(str)));
                return WebElementPickerImpl.this.canBeNegated;
            }
        }

        private class FinalPredicate
        implements Predicate<WebElement> {
            private FinalPredicate() {
            }

            public boolean apply(WebElement input) {
                WebElement transformed = WebElementPickerImpl.this.transFormIfNeeded(input);
                if (WebElementPickerImpl.this.predicates.size() == 1) {
                    return ((MergingPredicate)WebElementPickerImpl.this.predicates.peekFirst()).apply(input);
                }
                LinkedList predicatesCopy = new LinkedList(WebElementPickerImpl.this.predicates);
                LinkedList logicalFunctionsCopy = new LinkedList(WebElementPickerImpl.this.logicalFunctions);
                boolean previousResult = ((Predicate)predicatesCopy.removeFirst()).apply((Object)transformed);
                while (!logicalFunctionsCopy.isEmpty()) {
                    LogicalFunctions logicalFunction = (LogicalFunctions)((Object)logicalFunctionsCopy.removeFirst());
                    if (!previousResult && logicalFunction.equals((Object)LogicalFunctions.AND)) {
                        return previousResult;
                    }
                    previousResult = logicalFunction.apply(previousResult, (Predicate<WebElement>)((Predicate)predicatesCopy.removeFirst()), transformed);
                }
                return previousResult;
            }
        }

        private static enum LogicalFunctions {
            AND{

                @Override
                boolean apply(boolean b1, Predicate<WebElement> b2, WebElement e) {
                    return b1 && b2.apply((Object)e);
                }
            }
            ,
            OR{

                @Override
                boolean apply(boolean b1, Predicate<WebElement> b2, WebElement e) {
                    return b1 || b2.apply((Object)e);
                }
            };


            abstract boolean apply(boolean var1, Predicate<WebElement> var2, WebElement var3);
        }
    }

    public static interface WebElementPicking {
        public ComparationBy text();

        public ComparationBy attribute(String var1);

        public static interface WebElementPicker
        extends ChoicePicker,
        MultipleChoicePicker,
        WebElementPicking {
        }

        public static interface LogicalOperation
        extends ChoicePicker,
        MultipleChoicePicker {
            public WebElementPicking and();

            public WebElementPicking or();
        }

        public static interface CanBeNegated
        extends LogicalOperation {
            public LogicalOperation not();
        }

        public static interface ComparationBy {
            public CanBeNegated endsWith(String var1);

            public CanBeNegated equalTo(String var1);

            public CanBeNegated contains(String var1);

            public CanBeNegated matches(String var1);

            public CanBeNegated starstWith(String var1);
        }
    }

    public static class ByVisibleTextChoicePicker
    implements ChoicePicker,
    MultipleChoicePicker {
        private final List<Predicate> filters = Lists.newArrayList();
        private boolean allRulesMustPass = Boolean.TRUE;
        private Function<WebElement, WebElement> transformationFunction;

        private ByVisibleTextChoicePicker() {
        }

        public ByVisibleTextChoicePicker addFilter(Predicate<WebElement> filter) {
            this.filters.add(filter);
            return this;
        }

        public ByVisibleTextChoicePicker allRulesMustPass(boolean allRulesMustPass) {
            this.allRulesMustPass = allRulesMustPass;
            return this;
        }

        public ByVisibleTextChoicePicker contains(final String str) {
            return this.addFilter(new Predicate<WebElement>(){

                public boolean apply(WebElement input) {
                    return input.getText().contains(str);
                }

                public String toString() {
                    return "contains('" + str + "')";
                }
            });
        }

        public ByVisibleTextChoicePicker endsWith(final String str) {
            return this.addFilter(new Predicate<WebElement>(){

                public boolean apply(WebElement input) {
                    return input.getText().endsWith(str);
                }

                public String toString() {
                    return "endsWith('" + str + "')";
                }
            });
        }

        public ByVisibleTextChoicePicker match(final String str) {
            return this.addFilter(new Predicate<WebElement>(){

                public boolean apply(WebElement input) {
                    return input.getText().matches(str);
                }

                public String toString() {
                    return "matches('" + str + "')";
                }
            });
        }

        @Override
        public WebElement pick(List<WebElement> options) {
            List<WebElement> elements = this.pickInner(options, Boolean.TRUE);
            return elements == null || elements.isEmpty() ? null : elements.get(0);
        }

        private List<WebElement> pickInner(List<WebElement> options, boolean pickFirst) {
            Preconditions.checkNotNull(options, (Object)"Options cannot be null.");
            Preconditions.checkArgument((!this.filters.isEmpty() ? 1 : 0) != 0, (Object)"No filters specified.");
            if (options.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (pickFirst) {
                try {
                    return Lists.newArrayList((Object[])new WebElement[]{(WebElement)Iterables.find(options, (Predicate)new PickPredicate())});
                }
                catch (NoSuchElementException e) {
                    return Collections.EMPTY_LIST;
                }
            }
            return Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)Iterables.filter(options, (Predicate)new PickPredicate())));
        }

        @Override
        public List<WebElement> pickMultiple(List<WebElement> options) {
            return this.pickInner(options, Boolean.FALSE);
        }

        public void setTransformationFunction(Function<WebElement, WebElement> transformationFunction) {
            this.transformationFunction = transformationFunction;
        }

        public ByVisibleTextChoicePicker startsWith(final String str) {
            return this.addFilter(new Predicate<WebElement>(){

                public boolean apply(WebElement input) {
                    return input.getText().startsWith(str);
                }

                public String toString() {
                    return "startsWith('" + str + "')";
                }
            });
        }

        public String toString() {
            return this.filters.isEmpty() ? "no filters specified" : this.filters.toString();
        }

        private WebElement transFormIfNeeded(WebElement input) {
            return this.transformationFunction == null ? input : (WebElement)this.transformationFunction.apply((Object)input);
        }

        private class PickPredicate
        implements Predicate<WebElement> {
            private PickPredicate() {
            }

            public boolean apply(WebElement input) {
                WebElement element = ByVisibleTextChoicePicker.this.transFormIfNeeded(input);
                if (ByVisibleTextChoicePicker.this.allRulesMustPass) {
                    for (Predicate predicate : ByVisibleTextChoicePicker.this.filters) {
                        if (predicate.apply((Object)element)) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
                for (Predicate predicate : ByVisibleTextChoicePicker.this.filters) {
                    if (!predicate.apply((Object)element)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
    }

    public static class ByIndexChoicePicker
    implements ChoicePicker,
    MultipleChoicePicker {
        private final Set<Integer> reachableIndexes = new LinkedHashSet<Integer>();
        private final List<PreparationCommand> preparationCommands = Lists.newArrayList();

        private ByIndexChoicePicker() {
        }

        private void addReachableIndex(int index) {
            this.reachableIndexes.add(index);
        }

        public ByIndexChoicePicker beforeLast(final int positionsBeforeLast) {
            this.preparationCommands.add(new PreparationCommand(){

                @Override
                public void prepare(List<WebElement> list) {
                    int countedIndex = list.size() - 1 - positionsBeforeLast;
                    if (countedIndex >= 0 && countedIndex < list.size()) {
                        ByIndexChoicePicker.this.addReachableIndex(countedIndex);
                    }
                }
            });
            return this;
        }

        public ByIndexChoicePicker everyNth(int nth) {
            return this.everyNth(nth, 0);
        }

        public ByIndexChoicePicker everyNth(final int nth, final int from) {
            Preconditions.checkArgument((nth > 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((from >= 0 ? 1 : 0) != 0);
            this.preparationCommands.add(new PreparationCommand(){

                @Override
                public void prepare(List<WebElement> list) {
                    for (int i = from; i < list.size(); i += nth) {
                        ByIndexChoicePicker.this.addReachableIndex(i);
                    }
                }
            });
            return this;
        }

        public ByIndexChoicePicker first() {
            return this.index(0);
        }

        public ByIndexChoicePicker fromRange(final Range<Integer> range) {
            Preconditions.checkNotNull(range);
            this.preparationCommands.add(new PreparationCommand(){

                @Override
                public void prepare(List<WebElement> list) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (!range.contains((Comparable)Integer.valueOf(i))) continue;
                        ByIndexChoicePicker.this.addReachableIndex(i);
                    }
                }
            });
            return this;
        }

        public ByIndexChoicePicker index(final int index) {
            this.preparationCommands.add(new PreparationCommand(){

                @Override
                public void prepare(List<WebElement> list) {
                    if (list.size() > index && index >= 0) {
                        ByIndexChoicePicker.this.addReachableIndex(index);
                    }
                }
            });
            return this;
        }

        public ByIndexChoicePicker indexes(Integer ... indexes) {
            for (Integer integer : indexes) {
                this.index(integer);
            }
            return this;
        }

        public ByIndexChoicePicker last() {
            return this.beforeLast(0);
        }

        @Override
        public WebElement pick(List<WebElement> options) {
            List<WebElement> elements = this.pickInner(options, Boolean.TRUE);
            return elements.isEmpty() ? null : elements.get(0);
        }

        private List<WebElement> pickInner(List<WebElement> options, boolean pickFirst) {
            Preconditions.checkNotNull(options, (Object)"Options cannot be null.");
            Preconditions.checkArgument((!this.reachableIndexes.isEmpty() || !this.preparationCommands.isEmpty() ? 1 : 0) != 0, (Object)"No filter specified.");
            if (options.isEmpty()) {
                return Collections.emptyList();
            }
            for (PreparationCommand command : this.preparationCommands) {
                command.prepare(options);
            }
            if (this.reachableIndexes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayList();
            if (pickFirst) {
                result.add(options.get(this.reachableIndexes.iterator().next()));
            } else {
                for (Integer i : this.reachableIndexes) {
                    result.add(options.get(i));
                }
            }
            return result;
        }

        @Override
        public List<WebElement> pickMultiple(List<WebElement> options) {
            return this.pickInner(options, Boolean.FALSE);
        }

        public String toString() {
            return this.reachableIndexes.isEmpty() ? "unknown index picking" : this.reachableIndexes.toString();
        }

        private static interface PreparationCommand {
            public void prepare(List<WebElement> var1);
        }
    }
}

