/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.extendedDataTable;

import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.dataTable.AbstractTable;
import org.richfaces.fragment.extendedDataTable.ExtendedDataTable;

public abstract class RichFacesExtendedDataTable<HEADER, ROW, FOOTER>
extends AbstractTable<HEADER, ROW, FOOTER>
implements ExtendedDataTable {
    @FindByJQuery(value=".rf-edt-b .rf-edt-cnt tr")
    private List<WebElement> tableRowsElements;
    @FindByJQuery(value=".rf-edt-b .rf-edt-cnt tr:eq(0) td")
    private List<WebElement> firstRowCellsElements;
    @FindByJQuery(value=".rf-edt-b")
    private WebElement tableBodyElement;
    @FindBy(className="rf-edt-ndt")
    private WebElement noDataElement;
    @FindBy(className="rf-edt-tbl-hdr ")
    private WebElement headerElement;
    @FindBy(className="rf-edt-tbl-ftr")
    private WebElement footerElement;
    @FindBy(className="rf-edt-hdr-c")
    private List<WebElement> columnHeadersElements;
    @FindBy(className="rf-edt-ftr-c")
    private List<WebElement> columnFootersElements;
    private final AdvancedExtendedDataTableInteractions advancedInteractions = new AdvancedExtendedDataTableInteractions();

    @Override
    public void selectRow(int rowIndex, Keys ... keys) {
        this.clickOnRow(rowIndex, keys);
        Graphene.waitAjax().until().element(this.advanced().getTableRowsElements().get(rowIndex)).attribute("class").contains(this.advanced().getStyleClassForSelectedRow());
    }

    @Override
    public void deselectRow(int rowIndex, Keys ... keys) {
        this.clickOnRow(rowIndex, keys);
        ((StringMatcher)Graphene.waitAjax().until().element(this.advanced().getTableRowsElements().get(rowIndex)).attribute("class").not()).contains(this.advanced().getStyleClassForSelectedRow());
    }

    @Override
    public void selectAllRowsWithKeyShortcut() {
        this.advanced().getTableBodyElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        if (this.advanced().getTableRowsElements().size() >= 1) {
            Graphene.waitAjax().until().element(this.advanced().getTableRowsElements().get(0)).attribute("class").contains(this.advanced().getStyleClassForSelectedRow());
            Graphene.waitAjax().until().element(this.advanced().getTableRowsElements().get(this.advanced().getTableRowsElements().size() - 1)).attribute("class").contains(this.advanced().getStyleClassForSelectedRow());
        }
    }

    private void clickOnRow(int rowIndex, Keys ... keys) {
        this.checkSelectRowArguments(rowIndex, keys);
        Actions builder = new Actions(this.browser);
        for (Keys key : keys) {
            builder.keyDown(key).build().perform();
        }
        this.advanced().getCellElement(0, rowIndex).click();
        for (Keys key : keys) {
            builder.keyUp(key).build().perform();
        }
    }

    private void checkSelectRowArguments(int rowIndex, Keys ... keys) {
        if (rowIndex < 0) {
            throw new IllegalArgumentException("rowIndex must not be negative");
        }
        if (this.advanced().getNumberOfVisibleRows() < rowIndex) {
            throw new IllegalArgumentException("There is not so many rows! Requesting: " + rowIndex + "but there is only: " + this.advanced().getNumberOfVisibleRows());
        }
        if (keys.length > 2) {
            throw new IllegalArgumentException("Only one of: SHIFT, CTRL or their combination can be passed!");
        }
    }

    @Override
    public AdvancedExtendedDataTableInteractions advanced() {
        return this.advancedInteractions;
    }

    public class AdvancedExtendedDataTableInteractions
    extends AbstractTable.AdvancedTableInteractions {
        private static final String SELECTED_CLASS = "rf-edt-r-sel";

        protected String getStyleClassForSelectedRow() {
            return SELECTED_CLASS;
        }

        @Override
        public WebElement getNoDataElement() {
            return RichFacesExtendedDataTable.this.noDataElement;
        }

        @Override
        public List<WebElement> getTableRowsElements() {
            return RichFacesExtendedDataTable.this.tableRowsElements;
        }

        @Override
        public List<WebElement> getFirstRowCellsElements() {
            return RichFacesExtendedDataTable.this.firstRowCellsElements;
        }

        public ByJQuery getSelectorForCell(int column) {
            return ByJQuery.selector((String)(".rf-edt-c:eq(" + column + ")"));
        }

        @Override
        public WebElement getWholeTableHeaderElement() {
            return RichFacesExtendedDataTable.this.root;
        }

        @Override
        public WebElement getWholeTableFooterElement() {
            return RichFacesExtendedDataTable.this.root;
        }

        @Override
        public WebElement getHeaderElement() {
            return RichFacesExtendedDataTable.this.headerElement;
        }

        @Override
        public WebElement getFooterElement() {
            return RichFacesExtendedDataTable.this.footerElement;
        }

        @Override
        public List<WebElement> getColumnHeaderElements() {
            return RichFacesExtendedDataTable.this.columnHeadersElements;
        }

        @Override
        public List<WebElement> getColumnFooterElements() {
            return RichFacesExtendedDataTable.this.columnFootersElements;
        }

        public WebElement getTableBodyElement() {
            return RichFacesExtendedDataTable.this.tableBodyElement;
        }
    }
}

