/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.dataScroller;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.dataScroller.DataScroller;

public class RichFacesDataScroller
implements DataScroller,
AdvancedVisibleComponentIteractions<AdvancedDataScrollerInteractions> {
    @Root
    private WebElement root;
    @FindBy(className="rf-ds-btn-first")
    private GrapheneElement firstBtn;
    @FindBy(className="rf-ds-btn-fastrwd")
    private GrapheneElement fastRewindBtn;
    @FindBy(className="rf-ds-btn-prev")
    private GrapheneElement previousBtn;
    @FindBy(className="rf-ds-btn-next")
    private GrapheneElement nextBtn;
    @FindBy(className="rf-ds-btn-fastfwd")
    private GrapheneElement fastForwardBtn;
    @FindBy(className="rf-ds-btn-last")
    private GrapheneElement lastBtn;
    @FindBy(className="rf-ds-nmb-btn")
    private List<GrapheneElement> numberedPages;
    @FindBy(className="rf-ds-act")
    private GrapheneElement activePage;
    private final AdvancedDataScrollerInteractions advancedInteractions = new AdvancedDataScrollerInteractions();

    @Override
    public int getActivePageNumber() {
        return Integer.valueOf(this.advanced().getActivePageElement().getText());
    }

    private void switchTo(By by) {
        WebElement element = this.advanced().getRootElement().findElement(by);
        element.click();
        Graphene.waitModel().until().element(element).attribute("class").contains(this.advanced().getActiveClass());
    }

    private boolean checkIfScrollingByFastButtonIsQuickerThanScrollingByPages(int pageNumberBefore) {
        return Math.abs(pageNumberBefore - this.getActivePageNumber()) > this.advanced().getCountOfVisiblePages() / 2;
    }

    @Override
    public void switchTo(int pageNumber) {
        int counter;
        int lastPageNumber = this.getActivePageNumber();
        boolean isScrollingByFastButtonQuicker = true;
        boolean scrollingByButtonChecked = false;
        for (counter = 50; pageNumber > this.advanced().getLastVisiblePageNumber() && counter > 0; --counter) {
            if (isScrollingByFastButtonQuicker) {
                this.switchTo(DataScroller.DataScrollerSwitchButton.FAST_FORWARD);
            } else {
                this.switchTo(this.advanced().getLastVisiblePageNumber());
            }
            if (scrollingByButtonChecked) continue;
            isScrollingByFastButtonQuicker = this.checkIfScrollingByFastButtonIsQuickerThanScrollingByPages(lastPageNumber);
            scrollingByButtonChecked = true;
        }
        if (counter == 0) {
            throw new RuntimeException("Scroller doesn't change pages.");
        }
        for (counter = 50; pageNumber < this.advanced().getFirstVisiblePageNumber() && counter > 0; --counter) {
            if (isScrollingByFastButtonQuicker) {
                this.switchTo(DataScroller.DataScrollerSwitchButton.FAST_REWIND);
            } else {
                this.switchTo(this.advanced().getFirstVisiblePageNumber());
            }
            if (scrollingByButtonChecked) continue;
            isScrollingByFastButtonQuicker = this.checkIfScrollingByFastButtonIsQuickerThanScrollingByPages(lastPageNumber);
            scrollingByButtonChecked = true;
        }
        if (counter == 0) {
            throw new RuntimeException("Scroller doesn't change pages.");
        }
        if (pageNumber == this.getActivePageNumber()) {
            return;
        }
        this.switchTo(this.advanced().getCssSelectorForPageNumber(pageNumber));
    }

    @Override
    public void switchTo(DataScroller.DataScrollerSwitchButton btn) {
        String prevPageText = this.advanced().getActivePageElement().getText();
        this.advanced().getButtonElement(btn).click();
        ((StringMatcher)Graphene.waitModel().until().element(this.advanced().getActivePageElement()).text().not()).equalTo(prevPageText);
    }

    @Override
    public boolean hasPages() {
        return this.advanced().getCountOfVisiblePages() > 0;
    }

    @Override
    public AdvancedDataScrollerInteractions advanced() {
        return this.advancedInteractions;
    }

    public class AdvancedDataScrollerInteractions
    implements VisibleComponentInteractions {
        private static final String CSS_PAGE_SELECTOR_TEMPLATE = "[id$='ds_%d'].rf-ds-nmb-btn";
        private static final String CLASS_DISABLED = "rf-ds-dis";
        private static final String CLASS_ACTIVE = "rf-ds-act";

        public WebElement getRootElement() {
            return RichFacesDataScroller.this.root;
        }

        public WebElement getButtonElement(DataScroller.DataScrollerSwitchButton btn) {
            return this.getButtonGrapheneElement(btn);
        }

        private GrapheneElement getButtonGrapheneElement(DataScroller.DataScrollerSwitchButton btn) {
            switch (btn) {
                case FAST_FORWARD: {
                    return RichFacesDataScroller.this.fastForwardBtn;
                }
                case FAST_REWIND: {
                    return RichFacesDataScroller.this.fastRewindBtn;
                }
                case FIRST: {
                    return RichFacesDataScroller.this.firstBtn;
                }
                case LAST: {
                    return RichFacesDataScroller.this.lastBtn;
                }
                case NEXT: {
                    return RichFacesDataScroller.this.nextBtn;
                }
                case PREVIOUS: {
                    return RichFacesDataScroller.this.previousBtn;
                }
            }
            throw new UnsupportedOperationException("Unknown button " + (Object)((Object)btn));
        }

        protected String getActiveClass() {
            return CLASS_ACTIVE;
        }

        protected String getCssPageSelectorTemplate() {
            return CSS_PAGE_SELECTOR_TEMPLATE;
        }

        protected String getDisabledClass() {
            return CLASS_DISABLED;
        }

        private By getCssSelectorForPageNumber(int pageNumber) {
            return By.cssSelector((String)String.format(this.getCssPageSelectorTemplate(), pageNumber));
        }

        public List<? extends WebElement> getAllPagesElements() {
            return Collections.unmodifiableList(RichFacesDataScroller.this.numberedPages);
        }

        public WebElement getFirstVisiblePageElement() {
            return this.getAllPagesElements().get(0);
        }

        public int getFirstVisiblePageNumber() {
            return Integer.valueOf(this.getFirstVisiblePageElement().getText());
        }

        public WebElement getLastVisiblePageElement() {
            return this.getAllPagesElements().get(this.getCountOfVisiblePages() - 1);
        }

        public int getLastVisiblePageNumber() {
            return Integer.valueOf(this.getLastVisiblePageElement().getText());
        }

        public WebElement getActivePageElement() {
            return RichFacesDataScroller.this.activePage;
        }

        public int getCountOfVisiblePages() {
            return this.getAllPagesElements().size();
        }

        public boolean isButtonDisabled(DataScroller.DataScrollerSwitchButton btn) {
            return this.getButtonElement(btn).getAttribute("class").contains(this.getDisabledClass());
        }

        public boolean isButtonPresent(DataScroller.DataScrollerSwitchButton btn) {
            return this.getButtonGrapheneElement(btn).isPresent();
        }

        public boolean isFirstPage() {
            return Integer.valueOf(this.getActivePageElement().getText()).equals(1);
        }

        public boolean isLastPage() {
            return this.getActivePageElement().getText().equals(RichFacesDataScroller.this.advanced().getLastVisiblePageElement().getText());
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

