/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.editor;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.editor.Editor;
import org.richfaces.fragment.editor.toolbar.RichFacesEditorToolbar;

public class RichFacesEditor
implements Editor,
AdvancedVisibleComponentIteractions<AdvancedEditorInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private JavascriptExecutor executor;
    @FindBy(tagName="iframe")
    private WebElement frameElement;
    @FindBy(css=".cke_toolbox")
    private RichFacesEditorToolbar toolbar;
    private final AdvancedEditorInteractions advancedInteractions = new AdvancedEditorInteractions();

    @Override
    public AdvancedEditorInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public void clear() {
        this.advanced().clear(ClearType.JS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText() {
        try {
            String string = this.switchToEditorActiveArea().getText();
            return string;
        }
        finally {
            this.browser.switchTo().defaultContent();
        }
    }

    protected WebElement switchToEditorActiveArea() {
        this.browser.switchTo().frame(this.advanced().getFrameElement());
        WebElement activeArea = this.browser.findElement(By.tagName((String)"body"));
        activeArea.click();
        return activeArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void type(String text) {
        try {
            this.switchToEditorActiveArea().sendKeys(new CharSequence[]{""});
            this.executor.executeScript(String.format("document.body.textContent= document.body.textContent + '%s'", text), new Object[0]);
        }
        finally {
            this.browser.switchTo().defaultContent();
        }
    }

    protected JavascriptExecutor getExecutor() {
        return this.executor;
    }

    public class AdvancedEditorInteractions
    implements VisibleComponentInteractions {
        protected WebElement getFrameElement() {
            return RichFacesEditor.this.frameElement;
        }

        public WebElement getRootElement() {
            return RichFacesEditor.this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clear(ClearType clearType) {
            try {
                WebElement activeArea = RichFacesEditor.this.switchToEditorActiveArea();
                switch (clearType) {
                    case BACKSPACE: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case DELETE: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case ESCAPE_SQ: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case JS: {
                        RichFacesEditor.this.getExecutor().executeScript("arguments[0].innerHTML = '';", new Object[]{activeArea});
                        return;
                    }
                    case WD: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type of clear method " + (Object)((Object)clearType));
                    }
                }
            }
            finally {
                RichFacesEditor.this.browser.switchTo().defaultContent();
            }
        }

        public RichFacesEditorToolbar getToolbar() {
            return RichFacesEditor.this.toolbar;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

