/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.collapsiblePanel;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.collapsiblePanel.CollapsiblePanel;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Icon;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.panel.AbstractPanel;

public abstract class RichFacesCollapsiblePanel<HEADER, BODY>
extends AbstractPanel<HEADER, BODY>
implements CollapsiblePanel<HEADER, BODY>,
AdvancedVisibleComponentIteractions<AdvancedCollapsiblePanelInteractions> {
    @ArquillianResource
    private WebDriver browser;
    @FindBy(className="rf-cp-hdr")
    private GrapheneElement headerElement;
    @FindBy(className="rf-cp-ico")
    private Icon leftIconElement;
    @FindBy(className="rf-cp-exp-ico")
    private Icon rightIconElement;
    @FindBy(className="rf-cp-lbl")
    private GrapheneElement labelElement;
    @FindBy(className="rf-cp-b")
    private GrapheneElement bodyElement;
    @FindBy(className="rf-cp-empty")
    private GrapheneElement emptyBodyElement;
    private final AdvancedCollapsiblePanelInteractions interactions = new AdvancedCollapsiblePanelInteractions();

    @Override
    public AdvancedCollapsiblePanelInteractions advanced() {
        return this.interactions;
    }

    @Override
    public CollapsiblePanel<HEADER, BODY> collapse() {
        if (!this.advanced().isCollapsed()) {
            this.advanced().getHeaderElement().click();
            this.advanced().waitUntilPanelIsCollapsed().perform();
        }
        return this;
    }

    @Override
    public CollapsiblePanel<HEADER, BODY> expand() {
        if (this.advanced().isCollapsed()) {
            this.advanced().getHeaderElement().click();
            this.advanced().waitUntilPanelIsExpanded().perform();
        }
        return this;
    }

    public class AdvancedCollapsiblePanelInteractions
    extends AbstractPanel.AdvancedPanelInteractions
    implements VisibleComponentInteractions {
        private static final String COLLAPSED_HEADER_CLASS = "rf-cp-hdr-colps";
        private long _timeoutForPanelIsSwitched = -1L;

        protected GrapheneElement getEmptyBodyElement() {
            return RichFacesCollapsiblePanel.this.emptyBodyElement;
        }

        @Override
        public WebElement getBodyElement() {
            return Utils.isVisible((WebElement)RichFacesCollapsiblePanel.this.bodyElement) ? RichFacesCollapsiblePanel.this.bodyElement : this.getEmptyBodyElement();
        }

        protected String getCollapsedHeaderClass() {
            return COLLAPSED_HEADER_CLASS;
        }

        @Override
        public GrapheneElement getHeaderElement() {
            return RichFacesCollapsiblePanel.this.headerElement;
        }

        public WebElement getLabelElement() {
            return RichFacesCollapsiblePanel.this.labelElement;
        }

        public Icon getLeftIcon() {
            return RichFacesCollapsiblePanel.this.leftIconElement;
        }

        public Icon getRightIcon() {
            return RichFacesCollapsiblePanel.this.rightIconElement;
        }

        public long getTimeoutForPanelIsSwitched() {
            return this._timeoutForPanelIsSwitched == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesCollapsiblePanel.this.browser) : this._timeoutForPanelIsSwitched;
        }

        public boolean isCollapsed() {
            return this.getHeaderElement().getAttribute("class").contains(this.getCollapsedHeaderClass());
        }

        public void setTimeoutForPanelIsSwitched(long timeoutInMillis) {
            this._timeoutForPanelIsSwitched = timeoutInMillis;
        }

        public WaitingWrapper waitUntilPanelIsCollapsed() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver t) {
                            return AdvancedCollapsiblePanelInteractions.this.isCollapsed();
                        }
                    });
                }
            }.withMessage("Waiting for panel to collapse.").withTimeout(this.getTimeoutForPanelIsSwitched(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitUntilPanelIsExpanded() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver t) {
                            return !AdvancedCollapsiblePanelInteractions.this.isCollapsed();
                        }
                    });
                }
            }.withMessage("Waiting for panel to expand.").withTimeout(this.getTimeoutForPanelIsSwitched(), TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

