package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.ListType;
import org.richfaces.renderkit.ListRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;


public class ListRenderer extends ListRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES4 = attributes()
	     .bool("compact","compact")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("role","role")
	     

	     .generic("start","start")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES5 = attributes()
	     .bool("compact","compact")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("role","role")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES6 = attributes()
	     .bool("compact","compact")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("role","role")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
	
@Override
public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		String clientId = component.getClientId(facesContext);
ListType listType  =  (ListType)this.getType(component); 
String styleClass  =  (String)this.getStyleClass(component,listType); 
String elementId  =  (String)this.getElementId(facesContext,component); 
switch (listType) {
		case ordered:
	responseWriter.startElement("ol", component); 
	   {
      String value = styleClass;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = elementId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES4);

	encodeListItems(facesContext, component, listType);
	responseWriter.endElement("ol"); 
	
	break;
		case unordered:
	responseWriter.startElement("ul", component); 
	   {
      String value = styleClass;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = elementId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES5);

	encodeListItems(facesContext, component, listType);
	responseWriter.endElement("ul"); 
	
	break;
		case definitions:
	responseWriter.startElement("dl", component); 
	   {
      String value = styleClass;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = elementId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES6);

	encodeListItems(facesContext, component, listType);
	responseWriter.endElement("dl"); 
	
	break;
}

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

