/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.MethodExpression;
import javax.faces.component.UIComponentBase;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.attribute.AjaxProps;
import org.richfaces.component.attribute.CoreProps;
import org.richfaces.component.attribute.DisabledProps;
import org.richfaces.component.attribute.EventsKeyProps;
import org.richfaces.component.attribute.EventsMouseProps;
import org.richfaces.component.attribute.I18nProps;
import org.richfaces.event.FileUploadEvent;
import org.richfaces.event.FileUploadListener;
import org.richfaces.model.UploadedFile;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractFileUpload
extends UIComponentBase
implements AjaxProps,
CoreProps,
DisabledProps,
EventsKeyProps,
EventsMouseProps,
I18nProps {
    public static final String COMPONENT_TYPE = "org.richfaces.FileUpload";
    public static final String COMPONENT_FAMILY = "org.richfaces.FileUpload";
    private static final String QUEUED_FILE_UPLOAD_EVENTS_ATTR = "queuedFileUploadEvents";

    @Attribute
    public abstract String getAcceptedTypes();

    @Attribute(defaultValue="-1")
    public abstract Integer getMaxFilesQuantity();

    @Attribute(defaultValue="0L")
    public abstract long getMaxFileSize();

    @Attribute(defaultValue="false")
    public abstract boolean isNoDuplicate();

    @Attribute(defaultValue="false")
    public abstract boolean isImmediateUpload();

    @Attribute(events={@EventName(value="fileselect")})
    public abstract String getOnfileselect();

    @Attribute(events={@EventName(value="filesubmit")})
    public abstract String getOnfilesubmit();

    @Attribute(events={@EventName(value="typerejected")})
    public abstract String getOntyperejected();

    @Attribute(events={@EventName(value="sizerejected")})
    public abstract String getOnsizerejected();

    @Attribute(events={@EventName(value="uploadcomplete")})
    public abstract String getOnuploadcomplete();

    @Attribute(events={@EventName(value="clear")})
    public abstract String getOnclear();

    @Attribute(events={@EventName(value="error")})
    public abstract String getOnerror();

    @Attribute
    public abstract String getAddLabel();

    @Attribute
    public abstract String getUploadLabel();

    @Attribute
    public abstract String getClearAllLabel();

    @Attribute
    public abstract String getDoneLabel();

    @Attribute
    public abstract String getSizeExceededLabel();

    @Attribute
    public abstract String getServerErrorLabel();

    @Attribute
    public abstract String getClearLabel();

    @Attribute
    public abstract String getDeleteLabel();

    @Attribute(defaultValue="210px")
    public abstract String getListHeight();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event.getSource() == this && event instanceof PostAddToViewEvent) {
            this.getAttributes().put(QUEUED_FILE_UPLOAD_EVENTS_ATTR, new AtomicInteger(0));
        }
    }

    @Attribute
    public abstract MethodExpression getFileUploadListener();

    public void addFileUploadListener(FileUploadListener listener) {
        this.addFacesListener(listener);
    }

    public FileUploadListener[] getFileUploadListeners() {
        return (FileUploadListener[])this.getFacesListeners(FileUploadListener.class);
    }

    public void removeFileUploadListener(FileUploadListener listener) {
        this.removeFacesListener(listener);
    }

    public List<String> getAcceptedTypesList() {
        String acceptedTypes = this.getAcceptedTypes();
        if (acceptedTypes == null || acceptedTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(acceptedTypes.toLowerCase().replaceAll("\\.", "").split("\\s*,\\s*"));
    }

    public boolean acceptsFile(UploadedFile file) {
        String clientId = this.getClientId();
        int maxFilesQuantity = this.getMaxFilesQuantity();
        List<String> acceptedTypes = this.getAcceptedTypesList();
        if (maxFilesQuantity > 0 && this.queuedFileUploadEvents().get() >= maxFilesQuantity) {
            return false;
        }
        if (clientId.equals(file.getParameterName())) {
            if (acceptedTypes.isEmpty()) {
                return true;
            }
            if (acceptedTypes.contains(file.getFileExtension().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof FileUploadEvent) {
            this.queuedFileUploadEvents().addAndGet(1);
        }
        super.queueEvent(event);
    }

    private AtomicInteger queuedFileUploadEvents() {
        AtomicInteger i = (AtomicInteger)this.getAttributes().get(QUEUED_FILE_UPLOAD_EVENTS_ATTR);
        return i;
    }
}

