/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UpdateModelException;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.richfaces.application.FacesMessages;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractTreeNode;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.SwitchType;
import org.richfaces.component.TreeModelAdaptor;
import org.richfaces.component.TreeRange;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.component.attribute.AjaxProps;
import org.richfaces.component.attribute.CoreProps;
import org.richfaces.component.attribute.EventsKeyProps;
import org.richfaces.component.attribute.EventsMouseProps;
import org.richfaces.component.attribute.I18nProps;
import org.richfaces.component.attribute.ImmediateProps;
import org.richfaces.component.attribute.SequenceProps;
import org.richfaces.component.attribute.TreeCommonProps;
import org.richfaces.component.attribute.TreeProps;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.event.TreeSelectionChangeEvent;
import org.richfaces.event.TreeSelectionChangeListener;
import org.richfaces.event.TreeSelectionChangeSource;
import org.richfaces.event.TreeToggleEvent;
import org.richfaces.event.TreeToggleListener;
import org.richfaces.event.TreeToggleSource;
import org.richfaces.model.ClassicTreeNodeDataModelImpl;
import org.richfaces.model.DeclarativeModelKey;
import org.richfaces.model.DeclarativeTreeDataModelImpl;
import org.richfaces.model.DeclarativeTreeModel;
import org.richfaces.model.SwingTreeNodeDataModelImpl;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeDataModelTuple;
import org.richfaces.model.TreeDataVisitor;
import org.richfaces.model.TreeNode;
import org.richfaces.renderkit.MetaComponentRenderer;

public abstract class AbstractTree
extends UIDataAdaptor
implements MetaComponentResolver,
MetaComponentEncoder,
TreeSelectionChangeSource,
TreeToggleSource,
AjaxProps,
CoreProps,
EventsKeyProps,
EventsMouseProps,
ImmediateProps,
I18nProps,
SequenceProps,
TreeProps,
TreeCommonProps {
    public static final String COMPONENT_TYPE = "org.richfaces.Tree";
    public static final String COMPONENT_FAMILY = "org.richfaces.Tree";
    public static final String SELECTION_META_COMPONENT_ID = "selection";
    public static final String DEFAULT_TREE_NODE_ID = "__defaultTreeNode";
    public static final String DEFAULT_TREE_NODE_FACET_NAME = "__defaultTreeNode";
    private static final String COMPONENT_FOR_MODEL_UNAVAILABLE = "Component is not available for model {0}";
    private static final String CONVERTER_FOR_MODEL_UNAVAILABLE = "Row key converter is not available for model {0}";
    private transient TreeRange treeRange;
    private transient UIComponent currentComponent = this;
    private transient Map<String, UIComponent> declatariveModelsMap = null;

    public AbstractTree() {
        this.setKeepSaved(true);
        this.setRendererType("org.richfaces.TreeRenderer");
    }

    protected TreeRange getTreeRange() {
        if (this.treeRange == null) {
            this.treeRange = new TreeRange(this);
        }
        return this.treeRange;
    }

    @Attribute
    public abstract Object getValue();

    @Attribute
    public abstract String getNodeClass();

    @Attribute(events={@EventName(value="nodetoggle")})
    public abstract String getOnnodetoggle();

    @Attribute(events={@EventName(value="beforenodetoggle")})
    public abstract String getOnbeforenodetoggle();

    @Attribute(events={@EventName(value="selectionchange")})
    public abstract String getOnselectionchange();

    @Attribute(events={@EventName(value="beforeselectionchange")})
    public abstract String getOnbeforeselectionchange();

    @Attribute
    public abstract SwitchType getToggleType();

    @Attribute
    public abstract SwitchType getSelectionType();

    @Attribute
    public abstract String getNodeType();

    @Attribute
    public abstract String getToggleNodeEvent();

    public String getFamily() {
        return "org.richfaces.Tree";
    }

    @Attribute
    public Collection<Object> getSelection() {
        HashSet selection = (HashSet)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection));
        if (selection == null) {
            selection = new HashSet();
            ValueExpression ve = this.getValueExpression(PropertyKeys.selection.toString());
            if (ve != null) {
                ve.setValue(this.getFacesContext().getELContext(), selection);
            } else {
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), selection);
            }
        }
        return selection;
    }

    public void setSelection(Collection<Object> selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), selection);
    }

    protected DataComponentState createComponentState() {
        return null;
    }

    @Attribute
    public Converter getRowKeyConverter() {
        Converter converter = super.getRowKeyConverter();
        if (converter == null) {
            converter = this.getTreeDataModel().getRowKeyConverter();
        }
        return converter;
    }

    protected Iterator<UIComponent> findMatchingTreeNodeComponent(String nodeType, UIComponent parentComponent) {
        Iterator children = parentComponent.getChildren().iterator();
        if (parentComponent != this) {
            children = Iterators.concat(children, this.getChildren().iterator());
        }
        return Iterators.filter((Iterator)children, (Predicate)new MatchingTreeNodePredicate(nodeType));
    }

    protected void setupCurrentComponent() {
        ExtendedDataModel dataModel = this.getExtendedDataModel();
        this.currentComponent = dataModel instanceof DeclarativeTreeModel ? ((DeclarativeTreeModel)dataModel).getCurrentComponent() : this;
    }

    public AbstractTreeNode findTreeNodeComponent() {
        String nodeType = this.getNodeType();
        Iterator<UIComponent> nodesItr = this.findMatchingTreeNodeComponent(nodeType, this.currentComponent);
        if (nodesItr.hasNext()) {
            while (nodesItr.hasNext()) {
                AbstractTreeNode node = (AbstractTreeNode)nodesItr.next();
                if (!node.isRendered()) continue;
                return node;
            }
        } else if (Strings.isNullOrEmpty((String)nodeType)) {
            return (AbstractTreeNode)this.getFacet("__defaultTreeNode");
        }
        return null;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof TreeSelectionChangeEvent) {
            TreeSelectionChangeEvent selectionEvent = (TreeSelectionChangeEvent)event;
            final Collection<Object> newSelection = selectionEvent.getNewSelection();
            Collection<Object> selectionCollection = this.getSelection();
            Iterables.removeIf(selectionCollection, (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return !newSelection.contains(input);
                }
            });
            if (!newSelection.isEmpty()) {
                Iterables.addAll(selectionCollection, newSelection);
            }
        } else if (event instanceof TreeToggleEvent) {
            TreeToggleEvent toggleEvent = (TreeToggleEvent)event;
            AbstractTreeNode treeNodeComponent = this.findTreeNodeComponent();
            boolean newExpandedValue = toggleEvent.isExpanded();
            FacesContext context = this.getFacesContext();
            ValueExpression expression = treeNodeComponent.getValueExpression(AbstractTreeNode.PropertyKeys.expanded.toString());
            if (expression != null) {
                ELContext elContext = context.getELContext();
                Throwable caught = null;
                FacesMessage message = null;
                try {
                    expression.setValue(elContext, (Object)newExpandedValue);
                }
                catch (ELException e) {
                    caught = e;
                    String messageStr = e.getMessage();
                    for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                        messageStr = result.getMessage();
                    }
                    if (null == messageStr) {
                        MessageFactory messageFactory = (MessageFactory)ServiceTracker.getService(MessageFactory.class);
                        message = messageFactory.createMessage(context, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                    } else {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                    }
                }
                catch (Exception e) {
                    caught = e;
                    MessageFactory messageFactory = (MessageFactory)ServiceTracker.getService(MessageFactory.class);
                    message = messageFactory.createMessage(context, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                }
                if (caught != null) {
                    assert (message != null);
                    UpdateModelException toQueue = new UpdateModelException(message, caught);
                    ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, (Throwable)toQueue, (UIComponent)this, PhaseId.UPDATE_MODEL_VALUES);
                    context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)eventContext);
                }
            } else {
                treeNodeComponent.setExpanded(newExpandedValue);
            }
        }
    }

    protected boolean visitFixedChildren(VisitContext visitContext, VisitCallback callback) {
        VisitResult result;
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && ExtendedVisitContextMode.RENDER == (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() && (result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, SELECTION_META_COMPONENT_ID)) != VisitResult.ACCEPT) {
            return result == VisitResult.COMPLETE;
        }
        return super.visitFixedChildren(visitContext, callback);
    }

    void decodeMetaComponent(FacesContext context, String metaComponentId) {
        ((MetaComponentRenderer)this.getRenderer(context)).decodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        ((MetaComponentRenderer)this.getRenderer(context)).encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SELECTION_META_COMPONENT_ID.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    protected Iterator<UIComponent> dataChildren() {
        AbstractTreeNode treeNodeComponent = this.findTreeNodeComponent();
        if (treeNodeComponent != null) {
            return Iterators.singletonIterator((Object)treeNodeComponent);
        }
        return Iterators.emptyIterator();
    }

    @Override
    public void addTreeSelectionChangeListener(TreeSelectionChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Attribute(hidden=true)
    public TreeSelectionChangeListener[] getTreeSelectionChangeListeners() {
        return (TreeSelectionChangeListener[])this.getFacesListeners(TreeSelectionChangeListener.class);
    }

    @Override
    public void removeTreeSelectionChangeListener(TreeSelectionChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public void addTreeToggleListener(TreeToggleListener listener) {
        this.addFacesListener(listener);
    }

    @Attribute(hidden=true)
    public TreeToggleListener[] getTreeToggleListeners() {
        return (TreeToggleListener[])this.getFacesListeners(TreeToggleListener.class);
    }

    @Override
    public void removeTreeToggleListener(TreeToggleListener listener) {
        this.removeFacesListener(listener);
    }

    @Attribute(hidden=true)
    public boolean isExpanded() {
        if (this.getRowKey() == null) {
            return true;
        }
        AbstractTreeNode treeNode = this.findTreeNodeComponent();
        if (treeNode == null) {
            return false;
        }
        return treeNode.isExpanded();
    }

    protected TreeDataModel<?> getTreeDataModel() {
        return (TreeDataModel)this.getExtendedDataModel();
    }

    @Attribute(hidden=true)
    public boolean isLeaf() {
        return this.getTreeDataModel().isLeaf();
    }

    public void walk(final FacesContext faces, final DataVisitor visitor, final Object argument) {
        this.walkModel(faces, new TreeDataVisitor(){

            @Override
            public void enterNode() {
                visitor.process(faces, AbstractTree.this.getRowKey(), argument);
            }

            @Override
            public void exitNode() {
            }

            @Override
            public void beforeChildrenVisit() {
            }

            @Override
            public void afterChildrenVisit() {
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExtendedDataModel<?> createExtendedDataModel() {
        void var1_6;
        Object value = this.getValue();
        if (value == null) {
            DeclarativeTreeDataModelImpl declarativeTreeDataModelImpl = new DeclarativeTreeDataModelImpl(this);
            return var1_6;
        } else if (value instanceof TreeNode) {
            ClassicTreeNodeDataModelImpl classicTreeNodeDataModelImpl = new ClassicTreeNodeDataModelImpl();
            classicTreeNodeDataModelImpl.setWrappedData(value);
            return var1_6;
        } else if (value instanceof TreeDataModel) {
            if (!(value instanceof ExtendedDataModel)) throw new IllegalArgumentException(MessageFormat.format("TreeDataModel implementation {0} is not a subclass of ExtendedDataModel", value.getClass().getName()));
            ExtendedDataModel extendedDataModel = (ExtendedDataModel)value;
            return var1_6;
        } else {
            SwingTreeNodeDataModelImpl swingTreeNodeDataModelImpl = new SwingTreeNodeDataModelImpl();
            swingTreeNodeDataModelImpl.setWrappedData(value);
        }
        return var1_6;
    }

    public void walkModel(FacesContext context, TreeDataVisitor dataVisitor) {
        boolean isRootNode;
        TreeDataModel<?> model = this.getTreeDataModel();
        if (!this.getTreeRange().shouldProcessNode()) {
            return;
        }
        boolean bl = isRootNode = this.getRowKey() == null;
        if (!isRootNode) {
            dataVisitor.enterNode();
        }
        this.walkModelChildren(context, dataVisitor, model);
        if (!isRootNode) {
            dataVisitor.exitNode();
        }
    }

    private void walkModelChildren(FacesContext context, TreeDataVisitor dataVisitor, TreeDataModel<?> model) {
        if (!this.getTreeRange().shouldIterateChildren()) {
            return;
        }
        dataVisitor.beforeChildrenVisit();
        Iterator<TreeDataModelTuple> childrenTuples = model.children();
        while (childrenTuples.hasNext()) {
            TreeDataModelTuple tuple = childrenTuples.next();
            this.restoreFromSnapshot(context, tuple);
            if (!this.getTreeRange().shouldProcessNode()) continue;
            dataVisitor.enterNode();
            this.walkModelChildren(context, dataVisitor, model);
            dataVisitor.exitNode();
        }
        dataVisitor.afterChildrenVisit();
    }

    protected void resetDataModel() {
        super.resetDataModel();
        this.treeRange = null;
        this.declatariveModelsMap = null;
    }

    public TreeDataModelTuple createSnapshot() {
        return this.getTreeDataModel().createSnapshot();
    }

    public void restoreFromSnapshot(FacesContext context, TreeDataModelTuple tuple) {
        this.getTreeDataModel().restoreFromSnapshot(tuple);
        this.setRowKey(context, tuple.getRowKey());
    }

    protected void restoreChildState(FacesContext facesContext) {
        this.setupCurrentComponent();
        super.restoreChildState(facesContext);
    }

    protected UIComponent findDeclarativeModel(String modelId) {
        UIComponent adaptor;
        if (this.declatariveModelsMap == null) {
            this.declatariveModelsMap = Maps.newHashMap();
        }
        if ((adaptor = this.declatariveModelsMap.get(modelId)) == null && (adaptor = this.findComponent(modelId)) != null) {
            this.declatariveModelsMap.put(modelId, adaptor);
        }
        if (adaptor == null) {
            throw new IllegalStateException(MessageFormat.format(COMPONENT_FOR_MODEL_UNAVAILABLE, modelId));
        }
        return adaptor;
    }

    public String convertDeclarativeKeyToString(FacesContext context, DeclarativeModelKey declarativeKey) throws ConverterException {
        try {
            UIComponent component = this.findDeclarativeModel(declarativeKey.getModelId());
            TreeModelAdaptor adaptor = (TreeModelAdaptor)component;
            Converter rowKeyConverter = adaptor.getRowKeyConverter();
            if (rowKeyConverter == null) {
                throw new ConverterException(MessageFormat.format(CONVERTER_FOR_MODEL_UNAVAILABLE, declarativeKey.getModelId()));
            }
            return rowKeyConverter.getAsString(context, (UIComponent)adaptor, declarativeKey.getModelKey());
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e.getMessage(), (Throwable)e);
        }
    }

    public DeclarativeModelKey convertDeclarativeKeyFromString(FacesContext context, String modelId, String modelKeyAsString) throws ConverterException {
        try {
            UIComponent component = this.findDeclarativeModel(modelId);
            TreeModelAdaptor adaptor = (TreeModelAdaptor)component;
            Converter rowKeyConverter = adaptor.getRowKeyConverter();
            if (rowKeyConverter == null) {
                throw new ConverterException(MessageFormat.format(CONVERTER_FOR_MODEL_UNAVAILABLE, modelId));
            }
            Object modelKey = rowKeyConverter.getAsObject(context, (UIComponent)adaptor, modelKeyAsString);
            return new DeclarativeModelKey(modelId, modelKey);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e.getMessage(), (Throwable)e);
        }
    }

    private static enum PropertyKeys {
        selection;

    }

    private static final class MatchingTreeNodePredicate
    implements Predicate<UIComponent> {
        private String type;

        public MatchingTreeNodePredicate(String type) {
            this.type = type;
        }

        public boolean apply(UIComponent input) {
            if (!(input instanceof AbstractTreeNode)) {
                return false;
            }
            String nodeType = ((AbstractTreeNode)input).getType();
            if (this.type == null && nodeType == null) {
                return true;
            }
            return this.type != null && this.type.equals(nodeType);
        }
    }
}

