/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.JQueryAttachType;
import org.richfaces.component.JQueryTiming;
import org.richfaces.renderkit.JQueryRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

public class JQueryRenderer
extends JQueryRendererBase {
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH16 = RenderKitUtils.attributes().generic("event", "event", new String[0]).generic("query", "query", new String[0]);

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("span", component);
        String value = clientId;
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.writeAttribute("style", (Object)"display: none;", null);
        responseWriter.startElement("script", component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        Object functionName = component.getAttributes().get("name");
        LinkedHashMap options = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(options, (String)"selector", (Object)this.getEscapedSelector(facesContext, component), null, null);
        RenderKitUtils.addToScriptHash(options, (FacesContext)facesContext, (UIComponent)component, (RenderKitUtils.Attributes)ATTRIBUTES_FOR_SCRIPT_HASH16, null);
        RenderKitUtils.addToScriptHash(options, (String)"attachType", component.getAttributes().get("attachType"), (Object)((Object)JQueryAttachType.DEFAULT), null);
        RenderKitUtils.addToScriptHash(options, (String)"timing", component.getAttributes().get("timing"), (Object)((Object)JQueryTiming.DEFAULT), null);
        if (!JQueryRenderer.isEmpty(functionName)) {
            String text = JQueryRenderer.convertToString(functionName) + " = RichFaces.ui.jQueryComponent.createFunction(" + JQueryRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{options})) + ");";
            if (text != null) {
                responseWriter.writeText((Object)text, null);
            }
        } else {
            String text = "RichFaces.ui.jQueryComponent.query(" + JQueryRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{options})) + ");";
            if (text != null) {
                responseWriter.writeText((Object)text, null);
            }
        }
        responseWriter.endElement("script");
        responseWriter.endElement("span");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

