/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.joda.time.DateTime;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.FooterControls;
import org.richfaces.fragment.calendar.HeaderControls;
import org.richfaces.fragment.calendar.RichFacesAdvancedInlineCalendar;
import org.richfaces.fragment.calendar.TimeEditor;
import org.richfaces.fragment.common.Utils;

public class PopupCalendar
extends RichFacesAdvancedInlineCalendar {
    @FindBy(css="td[id$=Footer]")
    private PopupFooterControls popupFooterControls;
    @FindBy(css="td[id$=Header]")
    private PopupHeaderControls popupHeaderControls;

    @Override
    public PopupFooterControls getFooterControls() {
        this.popupFooterControls.setCalendarEditor(this.getCalendarEditor());
        return this.popupFooterControls;
    }

    @Override
    public PopupHeaderControls getHeaderControls() {
        this.popupHeaderControls.setCalendarEditor(this.getCalendarEditor());
        return this.popupHeaderControls;
    }

    @Override
    public WebElement getRoot() {
        return super.getRoot().findElement(By.cssSelector((String)"table.rf-cal-popup"));
    }

    @Override
    public void setDateTime(DateTime dt) {
        if (Utils.isVisible(this.getFooterControls().getApplyButtonElement())) {
            super.setDateTime(dt);
            this.getFooterControls().getApplyButtonElement().click();
        } else {
            this.getHeaderControls().openYearAndMonthEditor().selectDate(dt).confirmDate();
            this.getDayPicker().selectDayInMonth(dt);
            if (Utils.isVisible(this.getFooterControls().getTimeEditorOpenerElement())) {
                this.getFooterControls().openTimeEditor().setTime(dt, TimeEditor.SetValueBy.TYPING).confirmTime();
            }
        }
    }

    public static class PopupHeaderControls
    extends HeaderControls {
        @FindBy(css=".rf-cal-btn-close > div")
        private WebElement closeButtonElement;

        public void closePopup() {
            if (!this.isVisible() || !Utils.isVisible(this.closeButtonElement)) {
                throw new RuntimeException("Cannot interact with close button. Ensure that calendar popup and header controls are displayed.");
            }
            this.closeButtonElement.click();
            this.waitUntilIsNotVisible().perform();
        }

        public WebElement getCloseButtonElement() {
            return this.closeButtonElement;
        }
    }

    public static class PopupFooterControls
    extends FooterControls {
        @FindByJQuery(value="div.rf-cal-tl-btn:contains('Apply')")
        private WebElement applyButtonElement;

        public void applyDate() {
            if (!this.isVisible()) {
                throw new RuntimeException("Footer controls are not displayed, cannot interact with apply button");
            }
            if (!Utils.isVisible(this.applyButtonElement)) {
                throw new RuntimeException("Apply button is not displayed.");
            }
            this.applyButtonElement.click();
        }

        public WebElement getApplyButtonElement() {
            return this.applyButtonElement;
        }

        @Override
        public void setTodaysDate() {
            this.todayDate();
            if (Utils.isVisible(this.applyButtonElement)) {
                this.applyDate();
            }
        }

        @Override
        public void todayDate() {
            if (!this.isVisible()) {
                throw new RuntimeException("Footer controls are not displayed, cannot interact with today button");
            }
            if (!this.getTodayButtonElement().isDisplayed()) {
                throw new RuntimeException("Today button is not displayed.");
            }
            this.getTodayButtonElement().click();
        }
    }
}

