/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.status;

import com.google.common.base.Predicate;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.status.Status;

public class RichFacesStatus
implements Status,
AdvancedVisibleComponentIteractions<AdvancedStatusInteractions> {
    private static final String DISPLAY_NONE_REGEXP = ".*display:\\s?none;?.*";
    private static final String STYLE = "style";
    @Root
    private WebElement rootElement;
    @FindBy(className="rf-st-error")
    private WebElement errorElement;
    @FindBy(className="rf-st-start")
    private WebElement startElement;
    @FindBy(className="rf-st-stop")
    private WebElement stopElement;
    private final AdvancedStatusInteractions interactions = new AdvancedStatusInteractions();

    @Override
    public AdvancedStatusInteractions advanced() {
        return this.interactions;
    }

    @Override
    public Status.StatusState getStatusState() {
        if (!this.advanced().getStartElement().getAttribute(STYLE).matches(DISPLAY_NONE_REGEXP)) {
            return Status.StatusState.START;
        }
        if (!this.advanced().getStopElement().getAttribute(STYLE).matches(DISPLAY_NONE_REGEXP)) {
            return Status.StatusState.STOP;
        }
        return Status.StatusState.ERROR;
    }

    @Override
    public String getStatusText() {
        return this.advanced().getRootElement().getText();
    }

    public class AdvancedStatusInteractions
    implements VisibleComponentInteractions {
        public WebElement getErrorElement() {
            return RichFacesStatus.this.errorElement;
        }

        public WebElement getRootElement() {
            return RichFacesStatus.this.rootElement;
        }

        public WebElement getStartElement() {
            return RichFacesStatus.this.startElement;
        }

        public WebElement getStopElement() {
            return RichFacesStatus.this.stopElement;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }

        public WaitingWrapper waitUntilStatusStateChanges(final Status.StatusState state) {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return RichFacesStatus.this.getStatusState().equals((Object)state);
                        }
                    });
                }
            }.withMessage("Waiting for status state changes to <" + (Object)((Object)state) + ">");
        }

        public WaitingWrapper waitUntilStatusTextChanges(final String statusText) {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return RichFacesStatus.this.getStatusText().equals(statusText);
                        }
                    });
                }
            }.withMessage("Waiting for status text changes to <" + statusText + ">");
        }

        public WaitingWrapper waitUntilStatusTextChanges() {
            final String before = RichFacesStatus.this.getStatusText();
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !RichFacesStatus.this.getStatusText().equals(before);
                        }
                    });
                }
            }.withMessage("Waiting for status text changes from <" + before + "> to something else.");
        }
    }
}

