/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.cache.Cache;
import org.richfaces.cache.CacheFactory;
import org.richfaces.cache.OSCacheCache;
import org.richfaces.configuration.ConfigurationServiceHelper;
import org.richfaces.configuration.CoreConfiguration;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.util.URLToStreamHelper;

public class OSCacheCacheFactory
implements CacheFactory {
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private List<GeneralCacheAdministrator> cacheAdministrators = new ArrayList<GeneralCacheAdministrator>(1);

    public OSCacheCacheFactory() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = OSCacheCacheFactory.class.getClassLoader();
        }
        Class.forName(GeneralCacheAdministrator.class.getName(), false, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        URL resource = OSCacheCache.class.getResource("oscache.properties");
        if (resource != null) {
            InputStream stream = URLToStreamHelper.urlToStream(resource);
            try {
                properties.load(stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.debug(e.getMessage(), e);
                }
            }
        }
        return properties;
    }

    @Override
    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        Properties cacheProperties = new Properties();
        try {
            cacheProperties.putAll((Map<?, ?>)OSCacheCacheFactory.loadProperties());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        try {
            cacheProperties.putAll((Map<?, ?>)OSCacheCacheFactory.loadProperties());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        cacheProperties.putAll(env);
        LOG.info("Creating OSCache cache instance using parameters: " + cacheProperties);
        String property = cacheProperties.getProperty("cache.capacity");
        if (property == null) {
            int maxCacheSize = ConfigurationServiceHelper.getIntConfigurationValue(facesContext, CoreConfiguration.Items.resourcesCacheSize);
            LOG.info(MessageFormat.format("Maximum cache size hasn''t been set, resetting to {0} max items", maxCacheSize));
            cacheProperties.put("cache.capacity", Integer.toString(maxCacheSize));
        }
        GeneralCacheAdministrator cacheAdministrator = new GeneralCacheAdministrator(cacheProperties);
        this.cacheAdministrators.add(cacheAdministrator);
        return new OSCacheCache(cacheAdministrator.getCache());
    }

    @Override
    public void destroy() {
        for (GeneralCacheAdministrator cacheAdministrator : this.cacheAdministrators) {
            cacheAdministrator.destroy();
        }
        this.cacheAdministrators = null;
    }
}

