/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.ScriptsHolder;
import org.richfaces.ui.core.UIScripts;

public class JavaScriptServiceImpl
implements JavaScriptService {
    private static final ScriptsHolder EMPTY_SCRIPTS_HOLDER = new ScriptsHolder(){

        @Override
        public Collection<Object> getScripts() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> getPageReadyScripts() {
            return Collections.emptySet();
        }
    };

    @Override
    public <S> S addScript(FacesContext facesContext, S script) {
        UIScripts scriptResource = this.getOrCreateScriptResource(facesContext);
        return this.addOrFind(scriptResource.getScripts(), script);
    }

    @Override
    public <S> S addPageReadyScript(FacesContext facesContext, S script) {
        UIScripts scriptResource = this.getOrCreateScriptResource(facesContext);
        return this.addOrFind(scriptResource.getPageReadyScripts(), script);
    }

    private <S> S addOrFind(Collection<Object> collection, S script) {
        for (Object object : collection) {
            if (!script.equals(object)) continue;
            return (S)object;
        }
        collection.add(script);
        return script;
    }

    UIScripts getOrCreateScriptResource(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (null == viewRoot) {
            throw new FacesException("View is not created");
        }
        UIScripts scriptResource = this.findScriptResource(facesContext, viewRoot);
        if (null == scriptResource) {
            scriptResource = (UIScripts)facesContext.getApplication().createComponent("org.richfaces.Scripts");
            viewRoot.addComponentResource(facesContext, (UIComponent)scriptResource);
        }
        return scriptResource;
    }

    private UIScripts findScriptResource(FacesContext facesContext, UIViewRoot viewRoot) {
        List componentResources = viewRoot.getComponentResources(facesContext, "form");
        UIScripts scriptResource = this.findScriptComponent(componentResources);
        if (null == scriptResource) {
            componentResources = viewRoot.getComponentResources(facesContext, "body");
            scriptResource = this.findScriptComponent(componentResources);
        }
        return scriptResource;
    }

    private UIScripts findScriptComponent(List<UIComponent> componentResources) {
        for (UIComponent uiComponent : componentResources) {
            if (!(uiComponent instanceof UIScripts)) continue;
            UIScripts script = (UIScripts)uiComponent;
            return script;
        }
        return null;
    }

    @Override
    public ScriptsHolder getScriptsHolder(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        ScriptsHolder result = null;
        if (null != viewRoot) {
            result = this.findScriptResource(context, viewRoot);
        }
        if (null == result) {
            result = EMPTY_SCRIPTS_HOLDER;
        }
        return result;
    }
}

