/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.richfaces.convert.DeclarativeModelSequenceKeyConverter;
import org.richfaces.model.DeclarativeTreeDataModelTuple;
import org.richfaces.model.DeclarativeTreeModel;
import org.richfaces.model.SequenceRowKey;
import org.richfaces.model.TreeDataModelTuple;
import org.richfaces.model.TreeSequenceKeyModel;
import org.richfaces.model.iterators.DeclarativeTreeDataModelCompositeTuplesIterator;
import org.richfaces.ui.iteration.DeclarativeTreeDataModelWalker;
import org.richfaces.ui.iteration.tree.AbstractTree;
import org.richfaces.ui.iteration.tree.TreeModelAdaptor;
import org.richfaces.ui.iteration.tree.TreeModelRecursiveAdaptor;

public class DeclarativeTreeDataModelImpl
extends TreeSequenceKeyModel<Object>
implements DeclarativeTreeModel<Object> {
    private static final Converter DEFAULT_CONVERTER = new DeclarativeModelSequenceKeyConverter();
    private static final Predicate<Object> TREE_MODEL_ADAPTOR_INSTANCE_PREDICATE = Predicates.instanceOf(TreeModelAdaptor.class);
    private AbstractTree tree;
    private UIComponent currentComponent;

    public DeclarativeTreeDataModelImpl(AbstractTree tree) {
        this.tree = tree;
        this.currentComponent = tree;
    }

    @Override
    public UIComponent getCurrentComponent() {
        return this.currentComponent;
    }

    @Override
    public boolean isLeaf() {
        UIComponent currentComponent = this.getCurrentComponent();
        TreeModelAdaptor adaptor = (TreeModelAdaptor)currentComponent;
        if (adaptor.isLeaf()) {
            return true;
        }
        if (adaptor instanceof TreeModelRecursiveAdaptor) {
            return false;
        }
        if (currentComponent.getChildCount() == 0) {
            return true;
        }
        return !Iterables.any((Iterable)currentComponent.getChildren(), TREE_MODEL_ADAPTOR_INSTANCE_PREDICATE);
    }

    @Override
    public Iterator<TreeDataModelTuple> children() {
        return new DeclarativeTreeDataModelCompositeTuplesIterator(this.currentComponent, this.getRowKey());
    }

    @Override
    public Object getWrappedData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWrappedData(Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setupKey(SequenceRowKey key) {
        this.setRowKeyAndData(null, null);
        this.currentComponent = this.tree;
        if (key != null) {
            DeclarativeTreeDataModelWalker walker = new DeclarativeTreeDataModelWalker(FacesContext.getCurrentInstance(), this.tree);
            walker.walk(key);
            this.setRowKeyAndData(key, walker.getData());
            this.currentComponent = walker.getCurrentComponent();
        }
    }

    @Override
    public TreeDataModelTuple createSnapshot() {
        return new DeclarativeTreeDataModelTuple(this.getRowKey(), this.getData(), this.getCurrentComponent());
    }

    @Override
    public void restoreFromSnapshot(TreeDataModelTuple tuple) {
        DeclarativeTreeDataModelTuple declarativeModelTuple = (DeclarativeTreeDataModelTuple)tuple;
        this.setRowKeyAndData((SequenceRowKey)tuple.getRowKey(), tuple.getData());
        this.currentComponent = declarativeModelTuple.getComponent();
    }

    @Override
    public Converter getRowKeyConverter() {
        return DEFAULT_CONVERTER;
    }
}

