/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.push;

import java.io.IOException;
import org.richfaces.javascript.ScriptStringBase;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.push.MessageData;

public class MessageDataScriptString
extends ScriptStringBase {
    private static final String TOPIC_ATTRIBUTE = ScriptUtils.toScript("topic");
    private static final String DATA_ATTRIBUTE = ScriptUtils.toScript("data");
    private static final String NUMBER_ATTRIBUTE = ScriptUtils.toScript("number");
    private final Iterable<MessageData> messages;
    private long lastMessageNumber;

    public MessageDataScriptString(Iterable<MessageData> messages) {
        this.messages = messages;
    }

    private void appendMessageToScript(MessageData message, Appendable target) throws IOException {
        target.append('<');
        target.append(TOPIC_ATTRIBUTE);
        target.append(':');
        ScriptUtils.appendScript(target, message.getTopicKey().getTopicAddress());
        target.append(',');
        target.append(DATA_ATTRIBUTE);
        target.append(':');
        target.append(message.getSerializedMessage());
        target.append(',');
        target.append(NUMBER_ATTRIBUTE);
        target.append(':');
        ScriptUtils.appendScript(target, message.getSequenceNumber());
        target.append('>');
    }

    @Override
    public void appendScript(Appendable target) throws IOException {
        for (MessageData message : this.messages) {
            this.appendMessageToScript(message, target);
            this.lastMessageNumber = message.getSequenceNumber();
        }
    }

    public long getLastSequenceNumber() {
        return this.lastMessageNumber;
    }
}

