/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.push;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.richfaces.configuration.ConfigurationServiceHelper;
import org.richfaces.configuration.CoreConfiguration;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.push.JMSTopicsContextImpl;
import org.richfaces.push.PushContext;
import org.richfaces.push.SessionFactory;
import org.richfaces.push.SessionFactoryImpl;
import org.richfaces.push.SessionManager;
import org.richfaces.push.SessionManagerImpl;
import org.richfaces.push.TopicsContext;
import org.richfaces.push.TopicsContextImpl;

public class PushContextImpl
implements PushContext,
SystemEventListener {
    private static final ThreadFactory PUBLISH_THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("push-publish-thread-%1$s").build();
    private static final ThreadFactory SESSION_MANAGER_THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("push-session-manager-thread-%1$s").build();
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private String pushHandlerUrl;
    private TopicsContextImpl topicsContext;
    private SessionManager sessionManager;
    private SessionFactory sessionFactory;

    public PushContextImpl(String pushHandlerUrl) {
        this.pushHandlerUrl = pushHandlerUrl;
    }

    @Override
    public void init(FacesContext facesContext) {
        try {
            facesContext.getApplication().subscribeToEvent(PreDestroyApplicationEvent.class, (SystemEventListener)this);
            boolean isJmsEnabled = this.isJmsEnabled(facesContext);
            this.topicsContext = isJmsEnabled ? JMSTopicsContextImpl.getInstanceInitializedFromContext(PUBLISH_THREAD_FACTORY, facesContext) : new TopicsContextImpl(PUBLISH_THREAD_FACTORY);
            this.sessionManager = new SessionManagerImpl(SESSION_MANAGER_THREAD_FACTORY);
            this.sessionFactory = new SessionFactoryImpl(this.sessionManager, this.topicsContext);
            facesContext.getExternalContext().getApplicationMap().put(INSTANCE_KEY_NAME, this);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isJmsEnabled(FacesContext facesContext) {
        Boolean jmsEnabled = ConfigurationServiceHelper.getBooleanConfigurationValue(facesContext, CoreConfiguration.Items.pushJMSEnabled);
        jmsEnabled = jmsEnabled == null ? false : jmsEnabled;
        return jmsEnabled;
    }

    @Override
    public void destroy() {
        try {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        try {
            this.topicsContext.destroy();
            this.topicsContext = null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreDestroyApplicationEvent)) {
            throw new IllegalArgumentException(event.getClass().getName());
        }
        this.destroy();
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }

    @Override
    public TopicsContext getTopicsContext() {
        return this.topicsContext;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public String getPushHandlerUrl() {
        return this.pushHandlerUrl;
    }
}

