/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.Date;
import java.util.Map;
import javax.faces.FacesWrapper;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.richfaces.configuration.ConfigurationServiceHelper;
import org.richfaces.configuration.CoreConfiguration;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.resource.VersionedResource;

public abstract class BaseResourceWrapper<T>
extends AbstractCacheableResource
implements VersionedResource,
StateHolder,
FacesWrapper<T> {
    private T resourceObject;
    private boolean cacheable;
    private boolean versioned;

    public BaseResourceWrapper(T resourceObject, boolean cacheable, boolean versioned) {
        this.resourceObject = resourceObject;
        this.cacheable = cacheable;
        this.versioned = versioned;
    }

    protected abstract Map<String, String> getWrappedResourceResponseHeaders();

    @Override
    public Map<String, String> getResponseHeaders() {
        Map<String, String> headers = super.getResponseHeaders();
        Map<String, String> userHeaders = this.getWrappedResourceResponseHeaders();
        if (userHeaders != null) {
            headers.putAll(userHeaders);
        }
        return headers;
    }

    private String getPackageVersion() {
        Package pkg = this.resourceObject.getClass().getPackage();
        if (pkg != null) {
            return pkg.getImplementationVersion();
        }
        return null;
    }

    @Override
    public String getVersion() {
        if (this.resourceObject instanceof VersionedResource) {
            return ((VersionedResource)this.resourceObject).getVersion();
        }
        if (this.versioned) {
            String packageVersion = this.getPackageVersion();
            if (packageVersion != null) {
                return packageVersion;
            }
            return ConfigurationServiceHelper.getStringConfigurationValue(FacesContext.getCurrentInstance(), CoreConfiguration.Items.resourcesDefaultVersion);
        }
        return null;
    }

    @Override
    public boolean isCacheable(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).isCacheable(context);
        }
        return this.cacheable;
    }

    @Override
    public Date getExpires(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).getExpires(context);
        }
        return null;
    }

    @Override
    public String getEntityTag(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).getEntityTag(context);
        }
        return null;
    }

    @Override
    public int getTimeToLive(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).getTimeToLive(context);
        }
        return 0;
    }

    public boolean isTransient() {
        if (this.resourceObject instanceof StateHolderResource) {
            return ((StateHolderResource)this.resourceObject).isTransient();
        }
        if (this.resourceObject instanceof StateHolder) {
            return ((StateHolder)this.resourceObject).isTransient();
        }
        return true;
    }

    public void setTransient(boolean newTransientValue) {
        if (this.resourceObject instanceof StateHolder) {
            ((StateHolder)this.resourceObject).setTransient(newTransientValue);
        }
    }

    public Object saveState(FacesContext context) {
        return ResourceUtils.saveResourceState(context, this.resourceObject);
    }

    public void restoreState(FacesContext context, Object state) {
        ResourceUtils.restoreResourceState(context, this.resourceObject, state);
    }

    public T getWrapped() {
        return this.resourceObject;
    }
}

