/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ObjectStreamException;
import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.richfaces.configuration.ConfigurationService;
import org.richfaces.configuration.CoreConfiguration;
import org.richfaces.el.BaseReadOnlyValueExpression;
import org.richfaces.services.ServiceTracker;

public class GlobalResourcesViewHandler
extends ViewHandlerWrapper {
    private static final String SKINNING_RESOURCE_ID = "__rf_skinning_resource";
    private static final String CLASSES_ECSS = "_classes.ecss";
    private static final String ECSS = ".ecss";
    private static final String BOTH_ECSS = "_both.ecss";
    private static final String CONTROLS_SKINNING;
    private static final String BOTH_SKINNING;
    private static final String CLASSES_SKINNING;
    private static final String HEAD = "head";
    private ViewHandler viewHandler;

    public GlobalResourcesViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public ViewHandler getWrapped() {
        return this.viewHandler;
    }

    private UIComponent createComponentResource(FacesContext context) {
        Application application = context.getApplication();
        UIComponent resourceComponent = application.createComponent("javax.faces.Output");
        String rendererType = application.getResourceHandler().getRendererTypeForResourceName(BOTH_SKINNING);
        resourceComponent.setRendererType(rendererType);
        return resourceComponent;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = super.createView(context, viewId);
        boolean skinningResourceFound = false;
        List resources = viewRoot.getComponentResources(context, HEAD);
        for (UIComponent resource : resources) {
            if (!SKINNING_RESOURCE_ID.equals(resource.getId())) continue;
            skinningResourceFound = true;
            break;
        }
        if (!skinningResourceFound) {
            UIComponent basic = this.createComponentResource(context);
            basic.setValueExpression("name", SkinningResourceNameExpression.INSTANCE);
            basic.setValueExpression("rendered", SkinningResourceRenderedExpression.INSTANCE);
            basic.setId(SKINNING_RESOURCE_ID);
            boolean initialProcessingEvents = context.isProcessingEvents();
            context.setProcessingEvents(false);
            viewRoot.addComponentResource(context, basic);
            context.setProcessingEvents(initialProcessingEvents);
        }
        return viewRoot;
    }

    static {
        String skinningName = "skinning";
        CONTROLS_SKINNING = skinningName + ECSS;
        BOTH_SKINNING = skinningName + BOTH_ECSS;
        CLASSES_SKINNING = skinningName + CLASSES_ECSS;
    }

    private static final class SkinningResourceRenderedExpression
    extends BaseReadOnlyValueExpression {
        public static final ValueExpression INSTANCE = new SkinningResourceRenderedExpression();
        private static final long serialVersionUID = -1579256471133808739L;

        private SkinningResourceRenderedExpression() {
            super(Boolean.TYPE);
        }

        @Override
        public Object getValue(ELContext context) {
            FacesContext facesContext = this.getFacesContext(context);
            ConfigurationService configurationService = ServiceTracker.getService(ConfigurationService.class);
            return configurationService.getBooleanValue(facesContext, CoreConfiguration.Items.standardControlsSkinning) != false || configurationService.getBooleanValue(facesContext, CoreConfiguration.Items.standardControlsSkinningClasses) != false;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static final class SkinningResourceNameExpression
    extends BaseReadOnlyValueExpression {
        public static final ValueExpression INSTANCE = new SkinningResourceNameExpression();
        private static final long serialVersionUID = 7520575496522682120L;

        private SkinningResourceNameExpression() {
            super(String.class);
        }

        @Override
        public Object getValue(ELContext context) {
            FacesContext facesContext = this.getFacesContext(context);
            ConfigurationService configurationService = ServiceTracker.getService(ConfigurationService.class);
            boolean controls = configurationService.getBooleanValue(facesContext, CoreConfiguration.Items.standardControlsSkinning);
            boolean classes = configurationService.getBooleanValue(facesContext, CoreConfiguration.Items.standardControlsSkinningClasses);
            if (controls && classes) {
                return BOTH_SKINNING;
            }
            if (classes) {
                return CLASSES_SKINNING;
            }
            return CONTROLS_SKINNING;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

