/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractUserResource;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.ui.output.mediaOutput.AbstractMediaOutput;

@DynamicResource
public class MediaOutputResource
extends AbstractUserResource
implements StateHolder,
CacheableResource {
    private String contentType;
    private boolean cacheable;
    private MethodExpression contentProducer;
    private ValueExpression expiresExpression;
    private ValueExpression lastModifiedExpression;
    private ValueExpression timeToLiveExpression;
    private Object userData;
    private String fileName;

    @Override
    public void encode(FacesContext facesContext) throws IOException {
        OutputStream outStream = facesContext.getExternalContext().getResponseOutputStream();
        this.contentProducer.invoke(facesContext.getELContext(), new Object[]{outStream, this.userData});
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.isCacheable(context) ? Boolean.TRUE : Boolean.FALSE, this.getContentType(), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.userData), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.contentProducer), this.fileName};
        return state;
    }

    public void restoreState(FacesContext context, Object stateObject) {
        Object[] state = (Object[])stateObject;
        this.setCacheable((Boolean)state[0]);
        this.setContentType((String)state[1]);
        this.userData = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[2]);
        this.contentProducer = (MethodExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[3]);
        this.fileName = (String)state[4];
    }

    @PostConstructResource
    public void initialize() {
        AbstractMediaOutput uiMediaOutput = (AbstractMediaOutput)UIComponent.getCurrentComponent((FacesContext)FacesContext.getCurrentInstance());
        this.setCacheable(uiMediaOutput.isCacheable());
        this.setContentType(uiMediaOutput.getMimeType());
        this.userData = uiMediaOutput.getValue();
        this.contentProducer = uiMediaOutput.getCreateContent();
        this.lastModifiedExpression = uiMediaOutput.getValueExpression("lastModfied");
        this.expiresExpression = uiMediaOutput.getValueExpression("expires");
        this.timeToLiveExpression = uiMediaOutput.getValueExpression("timeToLive");
        this.fileName = uiMediaOutput.getFileName();
    }

    @Override
    public boolean isCacheable(FacesContext context) {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public Date getExpires(FacesContext context) {
        return null;
    }

    @Override
    public int getTimeToLive(FacesContext context) {
        return -1;
    }

    @Override
    public String getEntityTag(FacesContext context) {
        return null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        if (!Strings.isNullOrEmpty((String)this.fileName)) {
            headers.put("Content-Disposition", "inline; filename=\"" + this.fileName + "\"");
        }
        return headers;
    }
}

