/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceMappingFeature;
import org.richfaces.resource.ResourceSkinUtils;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.skin.SkinFactory;

public class ExternalStaticResource
extends ExternalResource {
    public static final String STATIC_RESOURCE_LOCATION_VARIABLE = "resourceLocation";
    private String location;
    private boolean skinDependent;

    public ExternalStaticResource(String location, boolean skinDependent) {
        this.location = location;
        this.skinDependent = skinDependent;
    }

    private String getResourceLocation(FacesContext facesContext) {
        if (this.skinDependent) {
            SkinFactory skinFactory = SkinFactory.getInstance(facesContext);
            String skinName = skinFactory.getSkin(facesContext).getName();
            return ResourceSkinUtils.evaluateSkinInPath(this.location, skinName);
        }
        return this.location;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestPath() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object resourceVarValue = requestMap.get(STATIC_RESOURCE_LOCATION_VARIABLE);
        try {
            String resourceLocation = this.getResourceLocation(facesContext);
            requestMap.put(STATIC_RESOURCE_LOCATION_VARIABLE, resourceLocation);
            String string = ResourceMappingFeature.getLocation();
            return string;
        }
        finally {
            requestMap.remove(STATIC_RESOURCE_LOCATION_VARIABLE);
            if (resourceVarValue != null) {
                requestMap.put(STATIC_RESOURCE_LOCATION_VARIABLE, resourceVarValue);
            }
        }
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getExternalLocation() {
        return this.location;
    }
}

