/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.faces;

import java.util.Collections;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.configuration.ConfigurationService;
import org.richfaces.configuration.ConfigurationServiceImpl;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.ExternalResourceTrackerWrapper;
import org.richfaces.resource.external.ExternalStaticResourceFactory;
import org.richfaces.resource.external.ExternalStaticResourceFactoryImpl;
import org.richfaces.resource.optimizer.Faces;
import org.richfaces.resource.optimizer.FileNameMapper;
import org.richfaces.resource.optimizer.faces.FacesContextImpl;
import org.richfaces.resource.optimizer.skin.SkinFactoryImpl;
import org.richfaces.services.DependencyInjectionServiceImpl;
import org.richfaces.services.DependencyInjector;
import org.richfaces.services.Module;
import org.richfaces.services.ServiceTracker;
import org.richfaces.services.ServicesFactory;
import org.richfaces.services.ServicesFactoryImpl;
import org.richfaces.skin.SkinFactory;

public class FacesImpl
implements Faces {
    private String webroot;
    private FileNameMapper fileNameMapper;
    private ResourceHandler resourceHandler;

    public FacesImpl(String webroot, FileNameMapper fileNameMapper, ResourceHandler resourceHandler) {
        this.webroot = webroot;
        this.fileNameMapper = fileNameMapper;
        this.resourceHandler = resourceHandler;
    }

    @Override
    public void start() {
        ServicesFactoryImpl serviceFactory = new ServicesFactoryImpl();
        Module module = new Module(){

            @Override
            public void configure(ServicesFactory factory) {
                factory.setInstance(ConfigurationService.class, new ConfigurationServiceImpl());
                factory.setInstance(SkinFactory.class, new SkinFactoryImpl());
                factory.setInstance(FileNameMapper.class, FacesImpl.this.fileNameMapper);
                factory.setInstance(DependencyInjector.class, new DependencyInjectionServiceImpl());
                factory.setInstance(ResourceHandler.class, FacesImpl.this.resourceHandler);
                factory.setInstance(ExternalResourceTracker.class, new ExternalResourceTrackerWrapper());
                factory.setInstance(ExternalStaticResourceFactory.class, new ExternalStaticResourceFactoryImpl());
            }
        };
        ServiceTracker.setFactory(serviceFactory);
        this.startRequest();
        serviceFactory.init(Collections.singleton(module));
        this.stopRequest();
    }

    @Override
    public void stop() {
        ServiceTracker.release();
    }

    @Override
    public void setSkin(String skinName) {
        SkinFactoryImpl.setSkinName(skinName);
    }

    @Override
    public FacesContext startRequest() {
        FacesContextImpl facesContextImpl = new FacesContextImpl();
        facesContextImpl.getExternalContext().setWebRoot(this.webroot);
        assert (FacesContext.getCurrentInstance() != null);
        return facesContextImpl;
    }

    @Override
    public void stopRequest() {
        FacesContext.getCurrentInstance().release();
        assert (FacesContext.getCurrentInstance() == null);
    }
}

