/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;

public class CSSCompressingProcessor
implements ResourceProcessor {
    private Charset charset;

    public CSSCompressingProcessor(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".css");
    }

    @Override
    public void process(String resourceName, InputSupplier<? extends InputStream> in, OutputSupplier<? extends OutputStream> out, boolean closeAtFinish) throws IOException {
        this.process(resourceName, (InputStream)in.getInput(), (OutputStream)out.getOutput(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String resourceName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        InputStreamReader reader = null;
        Writer writer = null;
        try {
            reader = new InputStreamReader(in, this.charset);
            writer = new OutputStreamWriter(out, this.charset);
            new CssCompressor((Reader)reader).compress(writer, 0);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            if (closeAtFinish) {
                Closeables.closeQuietly(writer);
            } else {
                writer.flush();
            }
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)reader);
        if (closeAtFinish) {
            Closeables.closeQuietly((Closeable)writer);
        } else {
            writer.flush();
        }
    }
}

