/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.mozilla.javascript.ErrorReporter;
import org.richfaces.log.Logger;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.MavenLogErrorReporter;

public class JavaScriptCompressingProcessor
implements ResourceProcessor {
    private Charset charset;
    private Logger log;

    public JavaScriptCompressingProcessor(Charset charset, Logger log) {
        this.charset = charset;
        this.log = log;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".js");
    }

    @Override
    public void process(String resourceName, InputSupplier<? extends InputStream> in, OutputSupplier<? extends OutputStream> out, boolean closeAtFinish) throws IOException {
        this.process(resourceName, (InputStream)in.getInput(), (OutputStream)out.getOutput(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String resourceName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        Writer writer;
        InputStreamReader reader;
        block8: {
            reader = null;
            writer = null;
            try {
                reader = new InputStreamReader(in, this.charset);
                writer = new OutputStreamWriter(out, this.charset);
                MavenLogErrorReporter reporter = new MavenLogErrorReporter(resourceName);
                new JavaScriptCompressor((Reader)reader, (ErrorReporter)reporter).compress(writer, 0, true, true, false, false);
                if (!closeAtFinish) {
                    writer.write(";");
                    writer.flush();
                }
                if (reporter.hasErrors() && this.log.isErrorEnabled()) {
                    this.log.error(reporter.getErrorsLog());
                }
                if (!reporter.hasWarnings() || !this.log.isDebugEnabled()) break block8;
                this.log.debug(reporter.getWarningsLog());
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                if (closeAtFinish) {
                    Closeables.closeQuietly(writer);
                } else {
                    writer.flush();
                }
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
        if (closeAtFinish) {
            Closeables.closeQuietly((Closeable)writer);
        } else {
            writer.flush();
        }
    }
}

