/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;

final class ThroughputResourceProcessor
implements ResourceProcessor {
    public static final ResourceProcessor INSTANCE = new ThroughputResourceProcessor();

    private ThroughputResourceProcessor() {
    }

    @Override
    public boolean isSupportedFile(String name) {
        return true;
    }

    @Override
    public void process(String resourceName, InputSupplier<? extends InputStream> in, OutputSupplier<? extends OutputStream> out, boolean closeAtFinish) throws IOException {
        this.process(resourceName, (InputStream)in.getInput(), (OutputStream)out.getOutput(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String resourceName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
            if (closeAtFinish) {
                Closeables.closeQuietly((Closeable)out);
            } else {
                out.flush();
            }
        }
    }
}

