/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.services;

import java.util.Map;
import org.richfaces.el.ValueExpressionAnalayserImpl;
import org.richfaces.javascript.ClientScriptService;
import org.richfaces.javascript.ClientScriptServiceImpl;
import org.richfaces.javascript.ClientServiceConfigParser;
import org.richfaces.javascript.LibraryFunction;
import org.richfaces.services.Module;
import org.richfaces.services.ServicesFactory;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.BeanValidatorServiceImpl;
import org.richfaces.validator.ConverterServiceImpl;
import org.richfaces.validator.DummyBeanValidatorService;
import org.richfaces.validator.FacesConverterService;
import org.richfaces.validator.FacesValidatorService;
import org.richfaces.validator.FacesValidatorServiceImpl;
import org.richfaces.validator.InitializationException;
import org.richfaces.validator.RichFacesBeanValidatorFactory;

public class ValidatorModule
implements Module {
    @Override
    public void configure(ServicesFactory factory) {
        this.configureBeanValidators(factory);
        factory.setInstance(FacesConverterService.class, new ConverterServiceImpl());
        factory.setInstance(FacesValidatorService.class, new FacesValidatorServiceImpl());
        ClientScriptServiceImpl clientScriptService = this.createClientScriptService();
        factory.setInstance(ClientScriptService.class, clientScriptService);
    }

    private ClientScriptServiceImpl createClientScriptService() {
        Map<Class<?>, LibraryFunction> config = ClientServiceConfigParser.parseConfig("META-INF/csv.xml");
        ClientScriptServiceImpl clientScriptService = new ClientScriptServiceImpl(config);
        return clientScriptService;
    }

    void configureBeanValidators(ServicesFactory factory) {
        BeanValidatorService service;
        try {
            RichFacesBeanValidatorFactory validatorFactory = new RichFacesBeanValidatorFactory();
            validatorFactory.init();
            service = new BeanValidatorServiceImpl(new ValueExpressionAnalayserImpl(), validatorFactory);
        }
        catch (InitializationException e) {
            service = new DummyBeanValidatorService();
        }
        catch (NoClassDefFoundError e) {
            service = new DummyBeanValidatorService();
        }
        factory.setInstance(BeanValidatorService.class, service);
    }
}

