/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.servlet;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.push.PushContextFactoryImpl;
import org.richfaces.servlet.AbstractServletContainerInitializer;
import org.richfaces.servlet.PushFilter;
import org.richfaces.servlet.PushServlet;

public class PushServletContainerInitializer
extends AbstractServletContainerInitializer {
    private static final Logger LOGGER = RichfacesLogger.WEBAPP.getLogger();
    private static final String ATMOSPHERE_SERVLET_CLASS = "org.atmosphere.cpr.AtmosphereServlet";
    private static final String SKIP_SERVLET_REGISTRATION_PARAM = "org.richfaces.push.skipPushServletRegistration";
    private static final String PUSH_CONTEXT_DEFAULT_MAPPING = "/__richfaces_push";

    private static void registerPushServlet(ServletContext context) {
        ServletRegistration.Dynamic dynamicRegistration = context.addServlet("AutoRegisteredPushServlet", PushServlet.class);
        dynamicRegistration.addMapping(new String[]{PUSH_CONTEXT_DEFAULT_MAPPING});
        dynamicRegistration.setAsyncSupported(true);
    }

    public void onStartup(Set<Class<?>> clasess, ServletContext servletContext) throws ServletException {
        if (Boolean.valueOf(servletContext.getInitParameter(SKIP_SERVLET_REGISTRATION_PARAM)).booleanValue()) {
            return;
        }
        if (!this.isAtmospherePresent()) {
            return;
        }
        if (this.hasFilterMapping(PushFilter.class, servletContext)) {
            return;
        }
        try {
            String pushHandlerMapping;
            ServletRegistration servletRegistration = this.getServletRegistration(PushServlet.class, servletContext);
            if (servletRegistration == null) {
                PushServletContainerInitializer.registerPushServlet(servletContext);
                pushHandlerMapping = PUSH_CONTEXT_DEFAULT_MAPPING;
            } else {
                pushHandlerMapping = (String)Iterables.get((Iterable)servletRegistration.getMappings(), (int)0);
            }
            servletContext.setAttribute(PushContextFactoryImpl.PUSH_HANDLER_MAPPING_ATTRIBUTE, (Object)pushHandlerMapping);
        }
        catch (Exception e) {
            servletContext.log(MessageFormat.format("Exception registering RichFaces Push Servlet: {0]", e.getMessage()), (Throwable)e);
        }
    }

    private boolean isAtmospherePresent() {
        try {
            Class.forName(ATMOSPHERE_SERVLET_CLASS, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("AtmosphereServlet class is not present in classpath, PushServlet won't be registered automatically");
        }
        catch (LinkageError e) {
            LOGGER.error(e.getMessage(), e);
        }
        return false;
    }
}

