/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.ajax.function;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.JSFunctionDefinition;
import org.richfaces.javascript.JSReference;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.ui.ajax.command.AjaxCommandRendererBase;
import org.richfaces.ui.common.AjaxFunction;
import org.richfaces.ui.common.AjaxOptions;
import org.richfaces.util.AjaxRendererUtils;

public abstract class AjaxFunctionRendererBase
extends AjaxCommandRendererBase {
    public String getFunction(FacesContext context, UIComponent component) {
        String functionName = (String)component.getAttributes().get("name");
        if (functionName == null) {
            throw new FacesException("Value of 'name' attribute of r:jsFunction component is null!");
        }
        StringBuilder script = new StringBuilder(functionName).append("=");
        JSFunctionDefinition func = new JSFunctionDefinition(new Object[0]);
        AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(context, component);
        ajaxFunction.setEvent(null);
        AjaxOptions options = ajaxFunction.getOptions();
        if (options.hasParameters()) {
            Map<String, Object> parameters = options.getParameters();
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                String name = parameter.getName();
                func.addParameter(name);
                JSReference reference = new JSReference(name);
                if (null != parameter.getValue()) {
                    reference = new JSReference(name + "||" + ScriptUtils.toScript(parameters.get(name)));
                }
                parameters.put(name, reference);
            }
        }
        func.addToBody(ajaxFunction.toScript());
        func.appendScriptToStringBuilder(script);
        return script.toString();
    }
}

