/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.common;

public enum PanelIcons {
    none("rf-ico-none"),
    chevron("rf-ico-chevron"),
    chevronLeft("rf-ico-chevron-left"),
    chevronUp("rf-ico-chevron-up"),
    chevronDown("rf-ico-chevron-down"),
    disc("rf-ico-disc"),
    grid("rf-ico-grid"),
    transparent("rf-ico-transparent"),
    triangle("rf-ico-triangle"),
    triangleLeft("rf-ico-triangle-left"),
    triangleUp("rf-ico-triangle-up"),
    triangleDown("rf-ico-triangle-down");

    public static final PanelIcons DEFAULT;
    private final String cssClass;
    private final String headerClass;
    private final String disabledCssClass;
    private final String disabledHeaderClass;

    private PanelIcons(String baseClass) {
        this.cssClass = baseClass;
        this.headerClass = baseClass + "-hdr";
        this.disabledCssClass = baseClass + "-dis";
        this.disabledHeaderClass = baseClass + "-hdr-dis";
    }

    private String cssClass() {
        return this.cssClass;
    }

    private String headerClass() {
        return this.headerClass;
    }

    private String disabledCssClass() {
        return this.disabledCssClass;
    }

    private String disabledHeaderClass() {
        return this.disabledHeaderClass;
    }

    public static PanelIcons getIcon(String attrIconCollapsedValue) {
        if (attrIconCollapsedValue == null) {
            return null;
        }
        try {
            return PanelIcons.valueOf(attrIconCollapsedValue);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        DEFAULT = none;
    }

    public static enum State {
        common{

            @Override
            public String getCssClass(PanelIcons icons) {
                return icons.cssClass();
            }
        }
        ,
        commonDisabled{

            @Override
            public String getCssClass(PanelIcons icons) {
                return icons.disabledCssClass();
            }
        }
        ,
        header{

            @Override
            public String getCssClass(PanelIcons icons) {
                return icons.headerClass();
            }
        }
        ,
        headerDisabled{

            @Override
            public String getCssClass(PanelIcons icons) {
                return icons.disabledHeaderClass();
            }
        };


        public abstract String getCssClass(PanelIcons var1);
    }
}

