/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.ui.common.meta.MetaComponentRenderer;
import org.richfaces.ui.iteration.AbstractTableBaseRenderer;
import org.richfaces.ui.iteration.EncodeStrategy;
import org.richfaces.ui.iteration.Row;
import org.richfaces.ui.iteration.RowHolder;
import org.richfaces.ui.iteration.RowHolderBase;
import org.richfaces.ui.iteration.UIDataTableBase;
import org.richfaces.util.HtmlUtil;

@ResourceDependencies(value={@ResourceDependency(name="richfaces-event.js")})
public abstract class AbstractTableRenderer
extends AbstractTableBaseRenderer
implements MetaComponentRenderer {
    public static final String HIDDEN_CONTAINER_ID = ":sc";

    public abstract EncodeStrategy getHiddenContainerStrategy(UIDataTableBase var1);

    public boolean isColumnAttributeSet(UIDataTableBase table, String attributeName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            result = component.isRendered() && null != component.getValueExpression(attributeName);
        }
        return result;
    }

    @Override
    public RowHolderBase createRowHolder(FacesContext context, UIComponent component, Object[] options) {
        RowHolder rowHolder = null;
        if (component instanceof UIDataTableBase) {
            rowHolder = new RowHolder(context, (UIDataTableBase)component);
            rowHolder.setUpdatePartial((Boolean)options[0]);
            rowHolder.setEncodeParentTBody((Boolean)options[1]);
        }
        return rowHolder;
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        this.decodeSortingFiltering(context, component);
    }

    protected void putRowStylesIntoContext(FacesContext facesContext, RowHolderBase rowHolder) {
        UIDataTableBase dataTableBase = (UIDataTableBase)rowHolder.getRow();
        String rowClass = this.getRowSkinClass();
        String cellClass = this.getCellSkinClass();
        String firstClass = this.getFirstRowSkinClass();
        rowClass = this.mergeStyleClasses("rowClass", rowClass, (UIComponent)dataTableBase);
        cellClass = this.mergeStyleClasses("cellClass", cellClass, (UIComponent)dataTableBase);
        firstClass = this.mergeStyleClasses("firstRowClass", firstClass, (UIComponent)dataTableBase);
        this.saveRowStyles(facesContext, dataTableBase.getClientId(facesContext), firstClass, rowClass, cellClass);
    }

    protected boolean isEncodeHeaders(UIDataTableBase table) {
        return table.isColumnFacetPresent("header") || this.isColumnAttributeSet(table, "sortBy") || this.isColumnAttributeSet(table, "comparator") || this.isColumnAttributeSet(table, "filterBy");
    }

    public void encodeTableStructure(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
    }

    public void encodeBeforeRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
    }

    public void encodeAfterRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
    }

    public abstract boolean encodeParentTBody(UIDataTableBase var1);

    public void encodeTableFacets(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        Object key = dataTable.getRowKey();
        dataTable.captureOrigValue(context);
        dataTable.setRowKey(context, null);
        this.encodeTableStructure(writer, context, dataTable);
        this.encodeHeaderFacet(writer, context, dataTable, false);
        this.encodeFooterFacet(writer, context, dataTable, false);
        dataTable.setRowKey(context, key);
        dataTable.restoreOrigValue(context);
    }

    public void encodeTableRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodePartialUpdate) throws IOException {
        int rowCount = dataTableBase.getRowCount();
        Object key = dataTableBase.getRowKey();
        dataTableBase.captureOrigValue(facesContext);
        dataTableBase.setRowKey(facesContext, null);
        boolean encodeParentTBody = this.encodeParentTBody(dataTableBase);
        this.encodeBeforeRows(writer, facesContext, dataTableBase, encodeParentTBody, encodePartialUpdate);
        if (rowCount > 0) {
            this.processRows(writer, facesContext, (UIComponent)dataTableBase, new Object[]{encodePartialUpdate, encodeParentTBody});
        } else {
            this.encodeNoDataFacetOrLabel(writer, facesContext, dataTableBase);
        }
        this.encodeAfterRows(writer, facesContext, dataTableBase, encodeParentTBody, encodePartialUpdate);
        if (encodePartialUpdate) {
            String id = dataTableBase.getClientId(facesContext) + HIDDEN_CONTAINER_ID;
            this.partialStart(facesContext, id);
        }
        this.encodeHiddens(writer, facesContext, dataTableBase, new Object[]{encodeParentTBody});
        if (encodePartialUpdate) {
            this.partialEnd(facesContext);
        }
        dataTableBase.setRowKey(facesContext, key);
        dataTableBase.restoreOrigValue(facesContext);
    }

    public void encodeNoDataFacetOrLabel(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        int columns = this.getColumnsCount(dataTableBase.columns());
        UIComponent noDataFacet = dataTableBase.getNoData();
        String noDataLabel = dataTableBase.getNoDataLabel();
        writer.startElement("tr", (UIComponent)dataTableBase);
        String styleClass = (String)dataTableBase.getAttributes().get("noDataStyleClass");
        styleClass = this.concatClasses(this.getNoDataClass(), styleClass);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("td", (UIComponent)dataTableBase);
        writer.writeAttribute("colspan", (Object)columns, null);
        String cellStyleClass = (String)dataTableBase.getAttributes().get("noDataCellStyleClass");
        cellStyleClass = this.concatClasses(this.getNoDataCellClass(), cellStyleClass);
        writer.writeAttribute("class", (Object)cellStyleClass, null);
        if (noDataFacet != null && noDataFacet.isRendered()) {
            noDataFacet.encodeAll(facesContext);
        } else if (noDataLabel != null && noDataLabel.length() > 0) {
            writer.writeText((Object)noDataLabel, "noDataLabel");
        } else {
            writer.writeAttribute("style", (Object)"display: none;", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
    }

    @Override
    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.preEncodeBegin(context, component);
        if (component instanceof UIDataTableBase) {
            ((UIDataTableBase)component).clearExtendedDataModel();
        }
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIDataTableBase) {
            this.encodeTableRows(writer, context, (UIDataTableBase)component, false);
        }
    }

    public void encodeTableStart(ResponseWriter writer, FacesContext context, UIDataTableBase component) throws IOException {
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        String styleClass = this.getTableSkinClass();
        this.encodeStyleClass(writer, context, (UIComponent)component, "styleClass", styleClass);
    }

    protected void encodeHiddens(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, Object[] params) throws IOException {
        EncodeStrategy encodeStrategy = this.getHiddenContainerStrategy(dataTableBase);
        if (encodeStrategy != null) {
            encodeStrategy.begin(writer, facesContext, (UIComponent)dataTableBase, params);
            this.encodeClientScript(writer, facesContext, dataTableBase);
            this.encodeHiddenInput(writer, facesContext, dataTableBase);
            encodeStrategy.end(writer, facesContext, (UIComponent)dataTableBase, params);
        }
    }

    public void encodeTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("table");
    }

    public abstract void encodeClientScript(ResponseWriter var1, FacesContext var2, UIDataTableBase var3) throws IOException;

    public abstract void encodeHiddenInput(ResponseWriter var1, FacesContext var2, UIDataTableBase var3) throws IOException;

    public void encodeTableBodyStart(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        writer.startElement("tbody", (UIComponent)dataTableBase);
        String clientId = dataTableBase.getRowKey() == null ? dataTableBase.getContainerClientId(facesContext) : dataTableBase.getRelativeClientId(facesContext);
        writer.writeAttribute("id", (Object)(clientId + ":tb"), null);
        writer.writeAttribute("class", (Object)this.getTableBodySkinClass(), null);
    }

    public void encodeTableBodyEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
    }

    public void encodeFooterFacet(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTable, boolean encodePartialUpdate) throws IOException {
        UIComponent footer = dataTable.getFooter();
        boolean columnFacetPresent = dataTable.isColumnFacetPresent("footer");
        if (footer != null && footer.isRendered() || columnFacetPresent) {
            String firstClass;
            String cellClass;
            String rowClass;
            boolean encodePartialUpdateForChildren;
            boolean partialUpdateEncoded = false;
            String clientId = dataTable.getClientId(facesContext);
            boolean encodeTfoot = this.containsThead();
            if (encodeTfoot) {
                String footerClientId = clientId + ":tf";
                if (encodePartialUpdate) {
                    partialUpdateEncoded = true;
                    this.partialStart(facesContext, footerClientId);
                }
                writer.startElement("tfoot", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)footerClientId, null);
                writer.writeAttribute("class", (Object)"rf-dt-tft", null);
            }
            int columns = this.getColumnsCount(dataTable.columns());
            boolean bl = encodePartialUpdateForChildren = encodePartialUpdate && !partialUpdateEncoded;
            if (columnFacetPresent) {
                rowClass = this.getColumnFooterSkinClass();
                cellClass = this.getColumnFooterCellSkinClass();
                firstClass = this.getColumnFooterFirstSkinClass();
                rowClass = this.mergeStyleClasses("columnFooterClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("columnFooterCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("firstColumnFooterClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(facesContext, clientId, firstClass, rowClass, cellClass);
                String targetId = clientId + ":cf";
                if (encodePartialUpdateForChildren) {
                    this.partialStart(facesContext, targetId);
                }
                writer.startElement("tr", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)targetId, null);
                this.encodeStyleClass(writer, facesContext, (UIComponent)dataTable, null, rowClass);
                this.encodeColumnFacet(facesContext, writer, dataTable, "footer", columns, cellClass);
                writer.endElement("tr");
                if (encodePartialUpdateForChildren) {
                    this.partialEnd(facesContext);
                }
            }
            if (footer != null && footer.isRendered()) {
                rowClass = this.getFooterSkinClass();
                cellClass = this.getFooterCellSkinClass();
                firstClass = this.getFooterFirstSkinClass();
                rowClass = this.mergeStyleClasses("footerClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("footerCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("footerFirstClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(facesContext, clientId, firstClass, rowClass, cellClass);
                this.encodeTableFacet(facesContext, writer, clientId, columns, footer, "footer", rowClass, cellClass, encodePartialUpdateForChildren);
            }
            if (encodeTfoot) {
                writer.endElement("tfoot");
                if (partialUpdateEncoded) {
                    this.partialEnd(facesContext);
                }
            }
        }
    }

    protected String mergeStyleClasses(String classAttribibute, String skinClass, UIComponent component) {
        String resultClass = skinClass;
        String styleClass = null;
        if (classAttribibute != null && component != null) {
            styleClass = (String)component.getAttributes().get(classAttribibute);
        }
        return HtmlUtil.concatClasses(resultClass, styleClass);
    }

    public void encodeHeaderFacet(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTable, boolean encodePartialUpdate) throws IOException {
        UIComponent header = dataTable.getHeader();
        boolean isEncodeHeaders = this.isEncodeHeaders(dataTable);
        boolean encodeThead = this.containsThead();
        if (header != null && header.isRendered() || isEncodeHeaders) {
            String firstClass;
            String cellClass;
            String rowClass;
            boolean encodePartialUpdateForChildren;
            String id = dataTable.getClientId(facesContext);
            boolean partialUpdateEncoded = false;
            String clientId = dataTable.getClientId(facesContext);
            if (encodeThead) {
                String headerClientId = clientId + ":th";
                if (encodePartialUpdate) {
                    partialUpdateEncoded = true;
                    this.partialStart(facesContext, headerClientId);
                }
                writer.startElement("thead", (UIComponent)dataTable);
                this.setCellElement(facesContext, id, "th");
                writer.writeAttribute("id", (Object)headerClientId, null);
                writer.writeAttribute("class", (Object)"rf-dt-thd", null);
            }
            int columns = this.getColumnsCount(dataTable.columns());
            boolean bl = encodePartialUpdateForChildren = encodePartialUpdate && !partialUpdateEncoded;
            if (header != null && header.isRendered()) {
                rowClass = this.getHeaderSkinClass();
                cellClass = this.getHeaderCellSkinClass();
                firstClass = this.getHeaderFirstSkinClass();
                rowClass = this.mergeStyleClasses("headerClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("headerCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("headerFirstClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(facesContext, clientId, firstClass, rowClass, cellClass);
                this.encodeTableFacet(facesContext, writer, clientId, columns, header, "header", rowClass, cellClass, encodePartialUpdateForChildren);
            }
            if (isEncodeHeaders) {
                rowClass = this.getColumnHeaderSkinClass();
                cellClass = this.getColumnHeaderCellSkinClass();
                firstClass = this.getColumnHeaderFirstSkinClass();
                rowClass = this.mergeStyleClasses("columnHeaderClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("columnHeaderCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("columnHeaderFirstClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(facesContext, clientId, firstClass, rowClass, cellClass);
                String targetId = clientId + ":ch";
                if (encodePartialUpdateForChildren) {
                    this.partialStart(facesContext, targetId);
                }
                writer.startElement("tr", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)targetId, null);
                this.encodeStyleClass(writer, facesContext, (UIComponent)dataTable, null, rowClass);
                this.encodeColumnFacet(facesContext, writer, dataTable, "header", columns, cellClass);
                writer.endElement("tr");
                if (encodePartialUpdateForChildren) {
                    this.partialEnd(facesContext);
                }
            }
            if (encodeThead) {
                this.setCellElement(facesContext, id, null);
                writer.endElement("thead");
                if (partialUpdateEncoded) {
                    this.partialEnd(facesContext);
                }
            }
        }
    }

    protected void encodeColumnFacet(FacesContext context, ResponseWriter writer, UIDataTableBase dataTableBase, String facetName, int colCount, String cellClass) throws IOException {
        int tColCount = 0;
        String id = dataTableBase.getClientId(context);
        String element = this.getCellElement(context, id);
        Iterator<UIComponent> headers = dataTableBase.columns();
        while (headers.hasNext()) {
            UIComponent column = headers.next();
            if (!column.isRendered() || column instanceof Row) continue;
            Integer colspan = (Integer)column.getAttributes().get("colspan");
            tColCount = colspan != null && colspan > 0 ? (tColCount += colspan.intValue()) : ++tColCount;
            if (tColCount > colCount) break;
            writer.startElement(element, column);
            this.encodeStyleClass(writer, context, column, facetName + "Class", cellClass);
            if ("th".equals(element)) {
                writer.writeAttribute("scope", (Object)"col", null);
            }
            this.getUtils().encodeAttribute(context, column, "colspan");
            EncodeStrategy strategy = this.getHeaderEncodeStrategy(column, facetName);
            if (strategy != null) {
                strategy.begin(writer, context, column, new String[]{facetName});
                UIComponent facet = column.getFacet(facetName);
                if (facet != null && facet.isRendered()) {
                    facet.encodeAll(context);
                }
                strategy.end(writer, context, column, new String[]{facetName});
            }
            writer.endElement(element);
        }
    }

    protected void encodeTableFacet(FacesContext facesContext, ResponseWriter writer, String id, int columns, UIComponent footer, String facetName, String rowClass, String cellClass, boolean encodePartialUpdate) throws IOException {
        boolean isColumnGroup = footer instanceof Row;
        String element = this.getCellElement(facesContext, id);
        boolean partialUpdateEncoded = false;
        if (!isColumnGroup) {
            String targetId = id + ":" + facetName.charAt(0);
            if (encodePartialUpdate) {
                partialUpdateEncoded = true;
                this.partialStart(facesContext, targetId);
            }
            writer.startElement("tr", footer);
            writer.writeAttribute("id", (Object)targetId, null);
            this.encodeStyleClass(writer, facesContext, footer, null, rowClass);
            writer.startElement(element, footer);
            this.encodeStyleClass(writer, facesContext, footer, null, cellClass);
            if (columns > 0) {
                writer.writeAttribute("colspan", (Object)String.valueOf(columns), null);
            }
            if ("th".equals(element)) {
                writer.writeAttribute("scope", (Object)"colgroup", null);
            }
        }
        if (encodePartialUpdate && !partialUpdateEncoded) {
            this.partialStart(facesContext, footer.getClientId(facesContext));
        }
        footer.encodeAll(facesContext);
        if (encodePartialUpdate && !partialUpdateEncoded) {
            this.partialEnd(facesContext);
        }
        if (isColumnGroup) {
            writer.endElement("tr");
        } else {
            writer.endElement(element);
            writer.endElement("tr");
            if (partialUpdateEncoded) {
                this.partialEnd(facesContext);
            }
        }
    }

    public abstract EncodeStrategy getHeaderEncodeStrategy(UIComponent var1, String var2);

    public abstract boolean containsThead();

    public abstract String getTableSkinClass();

    public abstract String getTableBodySkinClass();

    public abstract String getFirstRowSkinClass();

    public abstract String getRowSkinClass();

    public abstract String getHeaderCellSkinClass();

    public abstract String getHeaderSkinClass();

    public abstract String getHeaderFirstSkinClass();

    public abstract String getColumnHeaderCellSkinClass();

    public abstract String getColumnHeaderSkinClass();

    public abstract String getColumnHeaderFirstSkinClass();

    public abstract String getFooterCellSkinClass();

    public abstract String getFooterSkinClass();

    public abstract String getFooterFirstSkinClass();

    public abstract String getColumnFooterCellSkinClass();

    public abstract String getColumnFooterSkinClass();

    public abstract String getColumnFooterFirstSkinClass();

    public abstract String getCellSkinClass();

    public abstract String getNoDataClass();

    public abstract String getNoDataCellClass();

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        UIDataTableBase table = (UIDataTableBase)component;
        if ("header".equals(metaComponentId)) {
            this.encodeHeaderFacet(context.getResponseWriter(), context, table, true);
        } else if ("footer".equals(metaComponentId)) {
            this.encodeFooterFacet(context.getResponseWriter(), context, table, true);
        } else if ("body".equals(metaComponentId)) {
            this.encodeTableRows(context.getResponseWriter(), context, table, true);
        } else {
            throw new IllegalArgumentException("Unsupported metaComponentIdentifier: " + metaComponentId);
        }
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    protected void partialStart(FacesContext facesContext, String id) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(id);
    }

    protected void partialEnd(FacesContext facesContext) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
    }

    public class SimpleHeaderEncodeStrategy
    implements EncodeStrategy {
        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent column, Object[] params) throws IOException {
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent column, Object[] params) throws IOException {
        }
    }
}

