/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHelper;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.DataComponentState;
import org.richfaces.model.DataVisitResult;
import org.richfaces.model.DataVisitor;
import org.richfaces.model.ExtendedDataModel;
import org.richfaces.model.Range;
import org.richfaces.ui.iteration.DataAdaptorIterationState;
import org.richfaces.ui.iteration.DataComponentsContextUtil;
import org.richfaces.ui.iteration.IterationStateHolder;
import org.richfaces.ui.iteration.RowKeyContextEventWrapper;
import org.richfaces.ui.iteration.SavedState;
import org.richfaces.util.SeparatorChar;

public abstract class UIDataAdaptor
extends UIComponentBase
implements NamingContainer,
UniqueIdVendor,
IterationStateHolder,
ComponentSystemEventListener,
SystemEventListener {
    public static final String COMPONENT_FAMILY = "org.richfaces.Data";
    public static final String COMPONENT_TYPE = "org.richfaces.Data";
    private String PRE_RENDER_VIEW_EVENT_REGISTERED = UIDataAdaptor.class.getName() + ":preRenderViewEventRegistered";
    private static final VisitCallback STUB_CALLBACK = new VisitCallback(){

        public VisitResult visit(VisitContext context, UIComponent target) {
            return VisitResult.ACCEPT;
        }
    };
    private static final Logger LOG = RichfacesLogger.COMPONENTS.getLogger();
    protected ComponentVisitor decodeVisitor = new ComponentVisitor(){

        @Override
        public void processComponent(FacesContext context, UIComponent c, Object argument) {
            c.processDecodes(context);
        }
    };
    protected ComponentVisitor validateVisitor = new ComponentVisitor(){

        @Override
        public void processComponent(FacesContext context, UIComponent c, Object argument) {
            c.processValidators(context);
        }
    };
    protected ComponentVisitor updateVisitor = new ComponentVisitor(){

        @Override
        public void processComponent(FacesContext context, UIComponent c, Object argument) {
            c.processUpdates(context);
        }
    };
    private DataComponentState componentState = null;
    private ExtendedDataModel<?> extendedDataModel = null;
    private Object rowKey = null;
    private String containerClientId;
    private Object originalVarValue;
    private Converter rowKeyConverter;

    public UIDataAdaptor() {
        this.subscribeToEvents();
    }

    protected Map<String, Object> getVariablesMap(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap();
    }

    public String getFamily() {
        return "org.richfaces.Data";
    }

    public String createUniqueId(FacesContext context, String seed) {
        Integer i = (Integer)this.getStateHelper().get((Serializable)((Object)PropertyKeys.lastId));
        int lastId = i != null ? i : 0;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastId), (Object)(++lastId));
        return "j_id" + (seed == null ? Integer.valueOf(lastId) : seed);
    }

    public Object getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(FacesContext facesContext, Object rowKey) {
        this.saveChildState(facesContext);
        this.rowKey = rowKey;
        this.getExtendedDataModel().setRowKey(rowKey);
        this.containerClientId = null;
        boolean rowSelected = rowKey != null && this.isRowAvailable();
        this.setupVariable(facesContext, rowSelected);
        this.restoreChildState(facesContext);
    }

    protected void saveChildState(FacesContext facesContext) {
        Iterator<UIComponent> itr = this.dataChildren();
        while (itr.hasNext()) {
            this.saveChildState(facesContext, itr.next());
        }
    }

    protected void saveChildState(FacesContext facesContext, UIComponent component) {
        if (component.isTransient()) {
            return;
        }
        SavedState state = null;
        if (component instanceof IterationStateHolder) {
            IterationStateHolder ish = (IterationStateHolder)component;
            state = new SavedState(ish);
        } else if (component instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)component;
            state = new SavedState(evh);
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            state = new SavedState(form);
        }
        if (state != null) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.childState), component.getClientId(facesContext), (Object)state);
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.saveChildState(facesContext, child);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveChildState(facesContext, facet);
            }
        }
    }

    protected Iterator<UIComponent> dataChildren() {
        if (this.getChildCount() > 0) {
            return this.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected Iterator<UIComponent> fixedChildren() {
        if (this.getFacetCount() > 0) {
            return this.getFacets().values().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected Iterator<UIComponent> allFixedChildren() {
        if (this.getFacetCount() > 0) {
            return this.getFacets().values().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected void restoreChildState(FacesContext facesContext) {
        Iterator<UIComponent> itr = this.dataChildren();
        while (itr.hasNext()) {
            this.restoreChildState(facesContext, itr.next());
        }
    }

    protected void restoreChildState(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        component.setId(id);
        SavedState savedState = null;
        Map savedStatesMap = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.childState));
        if (savedStatesMap != null) {
            savedState = (SavedState)savedStatesMap.get(component.getClientId(facesContext));
        }
        if (savedState == null) {
            savedState = SavedState.EMPTY;
        }
        if (component instanceof IterationStateHolder) {
            IterationStateHolder ish = (IterationStateHolder)component;
            savedState.apply(ish);
        } else if (component instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)component;
            savedState.apply(evh);
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            savedState.apply(form);
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.restoreChildState(facesContext, child);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreChildState(facesContext, facet);
            }
        }
    }

    public void setRowKey(Object rowKey) {
        this.setRowKey(this.getFacesContext(), rowKey);
    }

    protected FacesEvent wrapEvent(FacesEvent event) {
        return new RowKeyContextEventWrapper(this, event, this.getRowKey());
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent(this.wrapEvent(event));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof RowKeyContextEventWrapper) {
            RowKeyContextEventWrapper eventWrapper = (RowKeyContextEventWrapper)event;
            eventWrapper.broadcast(this.getFacesContext());
        } else {
            super.broadcast(event);
        }
    }

    protected ExtendedDataModel<?> getExtendedDataModel() {
        if (this.extendedDataModel == null) {
            this.extendedDataModel = this.createExtendedDataModel();
        }
        return this.extendedDataModel;
    }

    protected abstract ExtendedDataModel<?> createExtendedDataModel();

    public void clearExtendedDataModel() {
        this.setExtendedDataModel(null);
    }

    protected void setExtendedDataModel(ExtendedDataModel<?> extendedDataModel) {
        this.extendedDataModel = extendedDataModel;
    }

    @Attribute
    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)var);
    }

    @Attribute
    public String getRowKeyVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.rowKeyVar));
    }

    public void setRowKeyVar(String rowKeyVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowKeyVar), (Object)rowKeyVar);
    }

    @Attribute
    public String getStateVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.stateVar));
    }

    public void setStateVar(String stateVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stateVar), (Object)stateVar);
    }

    public int getRowCount() {
        return this.getExtendedDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getExtendedDataModel().getRowData();
    }

    public boolean isRowAvailable() {
        return this.getExtendedDataModel().isRowAvailable();
    }

    @Attribute
    public boolean isKeepSaved() {
        Object value = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.keepSaved));
        if (value == null) {
            return this.keepSaved(this.getFacesContext());
        }
        return Boolean.valueOf(value.toString());
    }

    public void setKeepSaved(boolean keepSaved) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.keepSaved), (Object)keepSaved);
    }

    protected void setupVariable(FacesContext faces, boolean rowSelected) {
        Map<String, Object> attrs = this.getVariablesMap(faces);
        if (rowSelected) {
            this.setupVariable(this.getVar(), attrs, this.getRowData());
            this.setupVariable(this.getStateVar(), attrs, this.getComponentState());
            this.setupVariable(this.getRowKeyVar(), attrs, this.getRowKey());
        } else {
            this.removeVariable(this.getVar(), attrs);
            this.removeVariable(this.getStateVar(), attrs);
            this.removeVariable(this.getRowKeyVar(), attrs);
        }
    }

    public DataComponentState getComponentState() {
        if (this.componentState != null) {
            return this.componentState;
        }
        ValueExpression componentStateExpression = this.getValueExpression("componentState");
        if (componentStateExpression != null) {
            this.componentState = (DataComponentState)componentStateExpression.getValue(this.getFacesContext().getELContext());
        }
        if (this.componentState == null) {
            this.componentState = this.createComponentState();
            if (componentStateExpression != null && !componentStateExpression.isReadOnly(this.getFacesContext().getELContext())) {
                componentStateExpression.setValue(this.getFacesContext().getELContext(), (Object)this.componentState);
            }
        }
        return this.componentState;
    }

    protected abstract DataComponentState createComponentState();

    private void setupVariable(String var, Map<String, Object> attrs, Object rowData) {
        if (var != null) {
            attrs.put(var, rowData);
        }
    }

    private void removeVariable(String var, Map<String, Object> attrs) {
        if (var != null) {
            attrs.remove(var);
        }
    }

    @Attribute
    public Converter getRowKeyConverter() {
        if (this.rowKeyConverter != null) {
            return this.rowKeyConverter;
        }
        return (Converter)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowKeyConverter));
    }

    public void setRowKeyConverter(Converter converter) {
        StateHelper stateHelper = this.getStateHelper();
        if (this.initialStateMarked()) {
            stateHelper.put((Serializable)((Object)PropertyKeys.rowKeyConverterSet), (Object)Boolean.TRUE);
        }
        this.rowKeyConverter = converter;
    }

    private boolean isSetRowKeyConverter() {
        Boolean value = (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.rowKeyConverterSet));
        return Boolean.TRUE.equals(value);
    }

    private String getRowKeyAsString(FacesContext facesContext, Object rowKey) {
        assert (rowKey != null);
        Converter rowKeyConverter = this.getRowKeyConverter();
        if (rowKeyConverter == null && (rowKeyConverter = facesContext.getApplication().createConverter(rowKey.getClass())) != null) {
            this.setRowKeyConverter(rowKeyConverter);
        }
        if (rowKeyConverter != null) {
            return rowKeyConverter.getAsString(facesContext, (UIComponent)this, rowKey);
        }
        return rowKey.toString();
    }

    public String getContainerClientId() {
        return this.getContainerClientId(this.getFacesContext());
    }

    public String getContainerClientId(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException("context");
        }
        if (null == this.containerClientId) {
            this.containerClientId = super.getContainerClientId(facesContext);
            Object rowKey = this.getRowKey();
            if (rowKey != null) {
                String rowKeyString = this.getRowKeyAsString(facesContext, rowKey);
                this.containerClientId = SeparatorChar.JOINER.join(this.containerClientId, rowKeyString);
            }
        }
        return this.containerClientId;
    }

    public void captureOrigValue(FacesContext faces) {
        String var = this.getVar();
        if (var != null) {
            Map<String, Object> attrs = this.getVariablesMap(faces);
            this.originalVarValue = attrs.get(var);
        }
    }

    public void restoreOrigValue(FacesContext faces) {
        String var = this.getVar();
        if (var != null) {
            Map<String, Object> attrs = this.getVariablesMap(faces);
            if (this.originalVarValue != null) {
                attrs.put(var, this.originalVarValue);
            } else {
                attrs.remove(var);
            }
        }
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if ("var".equals(name) || "rowKeyVar".equals(name) || "stateVar".equals(name)) {
            throw new IllegalArgumentException(MessageFormat.format("{0} cannot be EL-expression", name));
        }
        super.setValueExpression(name, binding);
    }

    protected boolean keepSaved(FacesContext context) {
        FacesMessage.Severity sev = context.getMaximumSeverity();
        return sev != null && this.isErrorOrHigher(sev);
    }

    private boolean isErrorOrHigher(FacesMessage.Severity severity) {
        return FacesMessage.SEVERITY_ERROR.compareTo((Object)severity) <= 0;
    }

    protected void iterate(FacesContext faces, ComponentVisitor visitor) {
        if (!this.isRendered()) {
            return;
        }
        this.captureOrigValue(faces);
        this.setRowKey(faces, null);
        try {
            Iterator<UIComponent> fixedChildren = this.fixedChildren();
            while (fixedChildren.hasNext()) {
                UIComponent component = fixedChildren.next();
                visitor.processComponent(faces, component, null);
            }
            this.walk(faces, visitor, null);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.setRowKey(faces, null);
            this.restoreOrigValue(faces);
        }
    }

    public void walk(FacesContext faces, DataVisitor visitor, Object argument) {
        Object key = this.getRowKey();
        this.captureOrigValue(faces);
        Range range = null;
        DataComponentState componentState = this.getComponentState();
        if (componentState != null) {
            range = componentState.getRange();
        }
        this.getExtendedDataModel().walk(faces, visitor, range, argument);
        this.setRowKey(faces, key);
        this.restoreOrigValue(faces);
    }

    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(faces, (UIComponent)this);
        this.processDecodesChildren(faces);
        this.decode(faces);
        this.popComponentFromEL(faces);
    }

    public void processValidators(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(faces, (UIComponent)this);
        Application app = faces.getApplication();
        app.publishEvent(faces, PreValidateEvent.class, (Object)this);
        this.preValidate(faces);
        this.processValidatesChildren(faces);
        app.publishEvent(faces, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(faces);
    }

    public void processUpdates(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(faces, (UIComponent)this);
        this.preUpdate(faces);
        this.processUpdatesChildren(faces);
        this.doUpdate();
        this.popComponentFromEL(faces);
    }

    protected void doUpdate() {
    }

    protected void processDecodesChildren(FacesContext faces) {
        this.iterate(faces, this.decodeVisitor);
    }

    protected void processValidatesChildren(FacesContext faces) {
        this.iterate(faces, this.validateVisitor);
    }

    protected void processUpdatesChildren(FacesContext faces) {
        this.iterate(faces, this.updateVisitor);
    }

    public void setId(String id) {
        super.setId(id);
        this.containerClientId = null;
    }

    @Override
    public Object getIterationState() {
        assert (this.rowKey == null);
        return new DataAdaptorIterationState(this.componentState, this.extendedDataModel);
    }

    @Override
    public void setIterationState(Object stateObject) {
        assert (this.rowKey == null);
        if (stateObject != null) {
            DataAdaptorIterationState iterationState = (DataAdaptorIterationState)stateObject;
            iterationState.restoreComponentState(this);
            this.componentState = iterationState.getComponentState();
            this.extendedDataModel = iterationState.getDataModel();
        } else {
            this.componentState = null;
            this.extendedDataModel = null;
        }
    }

    protected void resetDataModel() {
        this.extendedDataModel = null;
    }

    protected void resetChildState() {
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.childState));
    }

    private void resetState() {
        DataComponentsContextUtil.resetDataModelOncePerPhase(this.getFacesContext(), (UIComponent)this);
        if (!this.isKeepSaved()) {
            this.resetChildState();
        }
    }

    protected void preDecode(FacesContext context) {
        this.resetState();
    }

    protected void preValidate(FacesContext context) {
    }

    protected void preUpdate(FacesContext context) {
    }

    protected void preEncodeBegin(FacesContext context) {
        this.resetState();
    }

    public void markInitialState() {
        super.markInitialState();
        if (this.rowKeyConverter instanceof PartialStateHolder) {
            ((PartialStateHolder)this.rowKeyConverter).markInitialState();
        }
    }

    public void clearInitialState() {
        super.clearInitialState();
        if (this.rowKeyConverter instanceof PartialStateHolder) {
            ((PartialStateHolder)this.rowKeyConverter).clearInitialState();
        }
    }

    public Object saveState(FacesContext context) {
        Object parentState = super.saveState(context);
        Object savedComponentState = new DataAdaptorIterationState(this.componentState, this.extendedDataModel).saveState(context);
        Object converterState = null;
        boolean nullDelta = true;
        boolean converterHasPartialState = false;
        if (this.initialStateMarked()) {
            if (!this.isSetRowKeyConverter() && this.rowKeyConverter != null && this.rowKeyConverter instanceof PartialStateHolder) {
                StateHolder holder = (StateHolder)this.rowKeyConverter;
                if (!holder.isTransient()) {
                    Object attachedState = holder.saveState(context);
                    if (attachedState != null) {
                        nullDelta = false;
                        converterState = attachedState;
                    }
                    converterHasPartialState = true;
                } else {
                    converterState = null;
                }
            } else if (this.isSetRowKeyConverter() || this.rowKeyConverter != null) {
                converterState = UIDataAdaptor.saveAttachedState((FacesContext)context, (Object)this.rowKeyConverter);
                nullDelta = false;
            }
            if (parentState == null && savedComponentState == null && nullDelta) {
                return null;
            }
        } else {
            converterState = UIDataAdaptor.saveAttachedState((FacesContext)context, (Object)this.rowKeyConverter);
        }
        return new Object[]{parentState, savedComponentState, converterHasPartialState, converterState};
    }

    public void restoreState(FacesContext context, Object stateObject) {
        if (stateObject == null) {
            return;
        }
        Object[] state = (Object[])stateObject;
        super.restoreState(context, state[0]);
        if (state[1] != null) {
            DataAdaptorIterationState iterationState = new DataAdaptorIterationState();
            iterationState.restoreState(context, state[1]);
            iterationState.restoreComponentState(this);
            this.componentState = iterationState.getComponentState();
            this.extendedDataModel = iterationState.getDataModel();
        }
        boolean converterHasPartialState = Boolean.TRUE.equals(state[2]);
        Object savedConverterState = state[3];
        if (converterHasPartialState) {
            ((StateHolder)this.rowKeyConverter).restoreState(context, savedConverterState);
        } else {
            this.rowKeyConverter = (Converter)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)savedConverterState);
        }
    }

    private boolean matchesBaseId(String clientId, String baseId, char separatorChar) {
        if (clientId.equals(baseId)) {
            return true;
        }
        return clientId.startsWith(baseId) && clientId.length() > baseId.length() && clientId.charAt(baseId.length()) == separatorChar;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        boolean found;
        block19: {
            if (null == context || null == clientId || null == callback) {
                throw new NullPointerException();
            }
            String baseId = this.getClientId(context);
            if (!this.matchesBaseId(clientId, baseId, UINamingContainer.getSeparatorChar((FacesContext)context))) {
                return false;
            }
            found = false;
            Object oldRowKey = this.getRowKey();
            this.captureOrigValue(context);
            try {
                Converter keyConverter;
                this.setRowKey(context, null);
                if (clientId.equals(baseId)) {
                    callback.invokeContextCallback(context, (UIComponent)this);
                    found = true;
                } else {
                    Iterator<UIComponent> fixedChildrenItr = this.fixedChildren();
                    while (fixedChildrenItr.hasNext() && !found) {
                        UIComponent fixedChild = fixedChildrenItr.next();
                        found = fixedChild.invokeOnComponent(context, clientId, callback);
                    }
                }
                if (found) break block19;
                Object newRowKey = null;
                String rowKeyString = this.extractKeySegment(context, clientId.substring(baseId.length() + 1));
                if (rowKeyString != null && null != (keyConverter = this.getRowKeyConverter())) {
                    try {
                        newRowKey = keyConverter.getAsObject(context, (UIComponent)this, rowKeyString);
                    }
                    catch (ConverterException e) {
                        // empty catch block
                    }
                }
                this.setRowKey(context, newRowKey);
                if (this.isRowAvailable()) {
                    Iterator<UIComponent> dataChildrenItr = this.dataChildren();
                    while (dataChildrenItr.hasNext() && !found) {
                        UIComponent dataChild = dataChildrenItr.next();
                        found = dataChild.invokeOnComponent(context, clientId, callback);
                    }
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                try {
                    this.setRowKey(context, oldRowKey);
                    this.restoreOrigValue(context);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return found;
    }

    public boolean invokeOnRow(FacesContext context, String clientId, ContextCallback callback) {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        String baseId = this.getClientId(context);
        if (!this.matchesBaseId(clientId, baseId, UINamingContainer.getSeparatorChar((FacesContext)context))) {
            return false;
        }
        String rowId = clientId.substring(baseId.length() + 1);
        if (rowId.indexOf(UINamingContainer.getSeparatorChar((FacesContext)context)) >= 0) {
            return false;
        }
        Object oldRowKey = this.getRowKey();
        this.captureOrigValue(context);
        try {
            Converter keyConverter;
            this.setRowKey(context, null);
            Iterator<UIComponent> fixedChildrenItr = this.fixedChildren();
            while (fixedChildrenItr.hasNext()) {
                if (!this.checkAllFixedChildren(fixedChildrenItr.next(), rowId)) continue;
                boolean bl = false;
                return bl;
            }
            Object newRowKey = null;
            if (rowId != null && null != (keyConverter = this.getRowKeyConverter())) {
                try {
                    newRowKey = keyConverter.getAsObject(context, (UIComponent)this, rowId);
                }
                catch (ConverterException e) {
                    LOG.warn(e);
                }
            }
            this.setRowKey(context, newRowKey);
            callback.invokeContextCallback(context, (UIComponent)this);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            try {
                this.setRowKey(context, oldRowKey);
                this.restoreOrigValue(context);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
        return true;
    }

    private boolean checkAllFixedChildren(UIComponent fixedChild, String id) {
        if (fixedChild.getId().equals(id)) {
            return true;
        }
        if (fixedChild instanceof NamingContainer) {
            return false;
        }
        for (UIComponent uiComponent : fixedChild.getChildren()) {
            if (!this.checkAllFixedChildren(uiComponent, id)) continue;
            return true;
        }
        for (UIComponent uiComponent : fixedChild.getFacets().values()) {
            if (!this.checkAllFixedChildren(uiComponent, id)) continue;
            return true;
        }
        return false;
    }

    private boolean doVisitChildren(VisitContext context, boolean visitRows) {
        if (visitRows) {
            this.setRowKey(context.getFacesContext(), null);
        }
        Collection idsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
        assert (idsToVisit != null);
        if (idsToVisit == VisitContext.ALL_IDS) {
            // empty if block
        }
        return !idsToVisit.isEmpty();
    }

    private boolean visitComponents(Iterator<UIComponent> components, VisitContext context, VisitCallback callback) {
        while (components.hasNext()) {
            UIComponent nextChild = components.next();
            if (!nextChild.visitTree(context, callback)) continue;
            return true;
        }
        return false;
    }

    protected boolean visitFixedChildren(VisitContext visitContext, VisitCallback callback) {
        return this.visitComponents(this.fixedChildren(), visitContext, callback);
    }

    protected VisitResult visitDataChildrenMetaComponents(ExtendedVisitContext extendedVisitContext, VisitCallback callback) {
        return VisitResult.ACCEPT;
    }

    protected boolean visitDataChildren(VisitContext visitContext, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            FacesContext facesContext = visitContext.getFacesContext();
            DataVisitorForVisitTree dataVisitor = new DataVisitorForVisitTree(callback, visitContext);
            this.walk(facesContext, dataVisitor, null);
            return dataVisitor.getVisitResult();
        }
        return this.visitComponents(this.getFacetsAndChildren(), visitContext, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        if (!this.isVisitable(visitContext)) {
            return false;
        }
        FacesContext facesContext = visitContext.getFacesContext();
        boolean visitRows = this.requiresRowIteration(visitContext);
        Object oldRowKey = null;
        if (visitRows) {
            this.captureOrigValue(facesContext);
            oldRowKey = this.getRowKey();
            this.setRowKey(facesContext, null);
        }
        this.pushComponentToEL(facesContext, null);
        try {
            VisitResult result = visitContext.invokeVisitCallback((UIComponent)this, callback);
            if (result == VisitResult.COMPLETE) {
                boolean bl = true;
                return bl;
            }
            if (result == VisitResult.ACCEPT && this.doVisitChildren(visitContext, visitRows)) {
                ExtendedVisitContext extendedVisitContext;
                Collection<String> directSubtreeIdsToVisit;
                if (visitRows) {
                    this.setRowKey(facesContext, null);
                }
                if (this.visitFixedChildren(visitContext, callback)) {
                    boolean bl = true;
                    return bl;
                }
                if (visitContext instanceof ExtendedVisitContext && (directSubtreeIdsToVisit = (extendedVisitContext = (ExtendedVisitContext)visitContext).getDirectSubtreeIdsToVisit((UIComponent)this)) != VisitContext.ALL_IDS) {
                    if (directSubtreeIdsToVisit.isEmpty()) {
                        boolean bl = false;
                        return bl;
                    }
                    VisitContext directChildrenVisitContext = extendedVisitContext.createNamingContainerVisitContext((UIComponent)this, directSubtreeIdsToVisit);
                    if (visitRows) {
                        this.setRowKey(facesContext, null);
                    }
                    if (this.visitFixedChildren(directChildrenVisitContext, STUB_CALLBACK)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (this.visitDataChildren(visitContext, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
            if (visitRows) {
                try {
                    this.setRowKey(facesContext, oldRowKey);
                    this.restoreOrigValue(facesContext);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return false;
    }

    private boolean requiresRowIteration(VisitContext context) {
        return !Boolean.TRUE.equals(context.getFacesContext().getAttributes().get("javax.faces.visit.SKIP_ITERATION"));
    }

    protected String extractKeySegment(FacesContext context, String substring) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        int separatorIndex = substring.indexOf(separatorChar);
        if (separatorIndex < 0) {
            return null;
        }
        return substring.substring(0, separatorIndex);
    }

    private void subscribeToEvents() {
        this.subscribeToEvent(PostAddToViewEvent.class, this);
        this.subscribeToEvent(PostRestoreStateEvent.class, this);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        this.processEvent((SystemEvent)event);
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext facesContext = this.getFacesContext();
        if (event instanceof PostAddToViewEvent) {
            this.subscribeToPreRenderViewEventOncePerRequest(facesContext, ((PostAddToViewEvent)event).getComponent());
        }
        if (event instanceof PostRestoreStateEvent) {
            this.subscribeToPreRenderViewEventOncePerRequest(facesContext, ((PostRestoreStateEvent)event).getComponent());
            this.preDecode(facesContext);
        }
        if (event instanceof PreRenderViewEvent) {
            this.preEncodeBegin(facesContext);
        }
    }

    private void subscribeToPreRenderViewEventOncePerRequest(FacesContext facesContext, UIComponent component) {
        Map contextMap = facesContext.getAttributes();
        if (contextMap.get(this.getClientId() + this.PRE_RENDER_VIEW_EVENT_REGISTERED) == null) {
            contextMap.put(this.getClientId() + this.PRE_RENDER_VIEW_EVENT_REGISTERED, Boolean.TRUE);
            UIViewRoot viewRoot = this.getUIViewRoot(component);
            viewRoot.subscribeToViewEvent(PreRenderViewEvent.class, (SystemEventListener)this);
        }
    }

    private UIViewRoot getUIViewRoot(UIComponent component) {
        UIComponent resolved = component;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (resolved instanceof UIViewRoot) {
                return (UIViewRoot)resolved;
            }
            resolved = resolved.getParent();
        }
        throw new IllegalStateException("No UIViewRoot found in tree");
    }

    public boolean isListenerForSource(Object source) {
        return this.equals(source) || source instanceof UIViewRoot;
    }

    protected DataComponentState getLocalComponentState() {
        return this.componentState;
    }

    protected abstract class ComponentVisitor
    implements DataVisitor {
        protected ComponentVisitor() {
        }

        @Override
        public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
            UIDataAdaptor.this.setRowKey(context, rowKey);
            if (UIDataAdaptor.this.isRowAvailable()) {
                Iterator<UIComponent> childIterator = UIDataAdaptor.this.dataChildren();
                while (childIterator.hasNext()) {
                    UIComponent component = childIterator.next();
                    this.processComponent(context, component, argument);
                }
            }
            return DataVisitResult.CONTINUE;
        }

        public abstract void processComponent(FacesContext var1, UIComponent var2, Object var3);
    }

    private static enum PropertyKeys {
        lastId,
        var,
        rowKeyVar,
        stateVar,
        childState,
        rowKeyConverter,
        rowKeyConverterSet,
        keepSaved;

    }

    private final class DataVisitorForVisitTree
    implements DataVisitor {
        private final VisitCallback callback;
        private final VisitContext visitContext;
        private boolean visitResult;

        private DataVisitorForVisitTree(VisitCallback callback, VisitContext visitContext) {
            this.callback = callback;
            this.visitContext = visitContext;
        }

        @Override
        public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
            UIDataAdaptor.this.setRowKey(context, rowKey);
            if (UIDataAdaptor.this.isRowAvailable()) {
                VisitResult result = VisitResult.ACCEPT;
                if (this.visitContext instanceof ExtendedVisitContext) {
                    result = this.visitContext.invokeVisitCallback((UIComponent)UIDataAdaptor.this, this.callback);
                    if (VisitResult.COMPLETE.equals((Object)result)) {
                        this.visitResult = true;
                        return DataVisitResult.STOP;
                    }
                    if (result == VisitResult.ACCEPT && VisitResult.COMPLETE.equals((Object)(result = UIDataAdaptor.this.visitDataChildrenMetaComponents((ExtendedVisitContext)this.visitContext, this.callback)))) {
                        this.visitResult = true;
                        return DataVisitResult.STOP;
                    }
                }
                if (VisitResult.ACCEPT.equals((Object)result)) {
                    Iterator<UIComponent> dataChildrenItr = UIDataAdaptor.this.dataChildren();
                    while (dataChildrenItr.hasNext()) {
                        UIComponent dataChild = dataChildrenItr.next();
                        if (!dataChild.visitTree(this.visitContext, this.callback)) continue;
                        this.visitResult = true;
                        return DataVisitResult.STOP;
                    }
                }
            }
            return DataVisitResult.CONTINUE;
        }

        public boolean getVisitResult() {
            return this.visitResult;
        }
    }
}

