/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.dataGrid;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.model.DataVisitResult;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.common.meta.MetaComponentRenderer;
import org.richfaces.ui.iteration.AbstractRowsRenderer;
import org.richfaces.ui.iteration.EncodeStrategy;
import org.richfaces.ui.iteration.Row;
import org.richfaces.ui.iteration.RowHolder;
import org.richfaces.ui.iteration.RowHolderBase;
import org.richfaces.ui.iteration.dataGrid.AbstractDataGrid;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="iteration/dataGrid/datagrid.ecss")})
public class DataGridRenderer
extends AbstractRowsRenderer
implements MetaComponentRenderer {
    private static final EncodeStrategy THEAD = new EncodeStrategy(){

        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            String clientId = component.getClientId(context) + ":h";
            boolean partial = (Boolean)params[0];
            if (partial) {
                context.getPartialViewContext().getPartialResponseWriter().startUpdate(clientId);
            }
            writer.startElement("thead", component);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"rf-dg-thead", null);
            writer.startElement("tr", component);
            writer.writeAttribute("class", (Object)"rf-dg-h", null);
            writer.startElement("th", component);
            writer.writeAttribute("class", (Object)"rf-dg-h-c", null);
            int columns = (Integer)component.getAttributes().get("columns");
            if (columns > 0) {
                writer.writeAttribute("colspan", (Object)columns, null);
            }
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.endElement("th");
            writer.endElement("tr");
            writer.endElement("thead");
            boolean partial = (Boolean)params[0];
            if (partial) {
                context.getPartialViewContext().getPartialResponseWriter().endUpdate();
            }
        }
    };
    private static final EncodeStrategy TFOOT = new EncodeStrategy(){

        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            String clientId = component.getClientId(context) + ":f";
            boolean partial = (Boolean)params[0];
            if (partial) {
                context.getPartialViewContext().getPartialResponseWriter().startUpdate(clientId);
            }
            writer.startElement("tfoot", component);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"rf-dg-tfoot", null);
            writer.startElement("tr", component);
            writer.writeAttribute("class", (Object)"rf-dg-f", null);
            writer.startElement("td", component);
            writer.writeAttribute("class", (Object)"rf-dg-f-c", null);
            int columns = (Integer)component.getAttributes().get("columns");
            if (columns > 0) {
                writer.writeAttribute("colspan", (Object)columns, null);
            }
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tfoot");
            boolean partial = (Boolean)params[0];
            if (partial) {
                context.getPartialViewContext().getPartialResponseWriter().endUpdate();
            }
        }
    };
    private static final EncodeStrategy CAPTION = new EncodeStrategy(){

        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.startElement("caption", component);
            writer.writeAttribute("class", (Object)"rf-dg-cap", null);
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.endElement("caption");
        }
    };
    private static final EncodeStrategy NODATA = new EncodeStrategy(){

        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.startElement("tr", component);
            writer.writeAttribute("class", (Object)"rf-dg-nd", null);
            writer.startElement("td", component);
            writer.writeAttribute("class", (Object)"rf-dg-nd-c", null);
            int columns = (Integer)component.getAttributes().get("columns");
            if (columns > 0) {
                writer.writeAttribute("colspan", (Object)columns, null);
            }
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.endElement("td");
            writer.endElement("tr");
        }
    };

    @Override
    public void encodeRow(ResponseWriter writer, FacesContext facesContext, RowHolderBase rowHolder) throws IOException {
        AbstractDataGrid dataGrid = (AbstractDataGrid)rowHolder.getRow();
        int columns = dataGrid.getColumns();
        int processCell = rowHolder.getProcessCell();
        if (columns > 0 && processCell % columns == 0) {
            if (processCell != 0) {
                writer.endElement("tr");
                rowHolder.resetProcessCell();
            }
            writer.startElement("tr", (UIComponent)dataGrid);
            writer.writeAttribute("class", (Object)"rf-dg-r", null);
            rowHolder.nextRow();
        }
        writer.startElement("td", (UIComponent)dataGrid);
        writer.writeAttribute("class", (Object)"rf-dg-c", null);
        this.renderChildren(facesContext, (UIComponent)dataGrid);
        writer.endElement("td");
    }

    public void encodeHeader(ResponseWriter writer, FacesContext facesContext, AbstractDataGrid dataGrid, boolean partial) throws IOException {
        UIComponent headerFacet = dataGrid.getHeader();
        this.encodeFacet(writer, facesContext, headerFacet, THEAD, dataGrid, new Object[]{partial});
    }

    public void encodeFooter(ResponseWriter writer, FacesContext facesContext, AbstractDataGrid dataGrid, boolean partial) throws IOException {
        UIComponent footerFacet = dataGrid.getFooter();
        this.encodeFacet(writer, facesContext, footerFacet, TFOOT, dataGrid, new Object[]{partial});
    }

    public void encodeCaption(ResponseWriter writer, FacesContext facesContext, AbstractDataGrid dataGrid) throws IOException {
        UIComponent captionFacet = dataGrid.getCaption();
        this.encodeFacet(writer, facesContext, captionFacet, CAPTION, dataGrid, null);
    }

    public void encodeNoData(ResponseWriter writer, FacesContext facesContext, AbstractDataGrid dataGrid) throws IOException {
        UIComponent noDataFacet = dataGrid.getNoData();
        this.encodeFacet(writer, facesContext, noDataFacet, NODATA, dataGrid, null);
    }

    public void encodeFacet(ResponseWriter writer, FacesContext facesContext, UIComponent facet, EncodeStrategy strategy, AbstractDataGrid dataGrid, Object[] params) throws IOException {
        if (facet != null && facet.isRendered()) {
            strategy.begin(writer, facesContext, (UIComponent)dataGrid, params);
            facet.encodeAll(facesContext);
            strategy.end(writer, facesContext, (UIComponent)dataGrid, params);
        }
    }

    public void encodeTBody(ResponseWriter writer, FacesContext facesContext, AbstractDataGrid dataGrid, boolean partial) throws IOException {
        String clientId = dataGrid.getClientId(facesContext) + ":dgb";
        if (partial) {
            facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(clientId);
        }
        writer.startElement("tbody", (UIComponent)dataGrid);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"rf-dg-body", null);
        if (dataGrid.getRowCount() > 0) {
            this.processRows(writer, facesContext, (UIComponent)dataGrid, null);
        } else {
            this.encodeNoData(writer, facesContext, dataGrid);
        }
        writer.endElement("tbody");
        if (partial) {
            facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
        }
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext facesContext, UIComponent component) throws IOException {
        AbstractDataGrid dataGrid = (AbstractDataGrid)component;
        writer.startElement("table", (UIComponent)dataGrid);
        writer.writeAttribute("id", (Object)dataGrid.getClientId(facesContext), null);
        Map attributes = dataGrid.getAttributes();
        String classes = this.concatClasses("rf-dg", attributes.get("styleClass"));
        writer.writeAttribute("class", (Object)classes, null);
        RenderKitUtils.renderAttribute(facesContext, "style", attributes.get("style"));
        RenderKitUtils.renderAttribute(facesContext, "title", attributes.get("title"));
        this.encodeCaption(writer, facesContext, dataGrid);
        this.encodeHeader(writer, facesContext, dataGrid, false);
        this.encodeFooter(writer, facesContext, dataGrid, false);
        this.encodeTBody(writer, facesContext, dataGrid, false);
        writer.endElement("table");
    }

    @Override
    public RowHolderBase createRowHolder(FacesContext context, UIComponent component, Object[] options) {
        return new RowHolder(context, (AbstractDataGrid)component);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractDataGrid.class;
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        AbstractDataGrid table = (AbstractDataGrid)component;
        if ("header".equals(metaComponentId)) {
            this.encodeHeader(context.getResponseWriter(), context, table, true);
        } else if ("footer".equals(metaComponentId)) {
            this.encodeFooter(context.getResponseWriter(), context, table, true);
        } else if ("body".equals(metaComponentId)) {
            this.encodeTBody(context.getResponseWriter(), context, table, true);
        } else {
            throw new IllegalArgumentException("Unsupported metaComponentIdentifier: " + metaComponentId);
        }
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doCleanup(FacesContext context, RowHolderBase rowHolder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        AbstractDataGrid dataGrid = (AbstractDataGrid)rowHolder.getRow();
        int cell = rowHolder.getProcessCell();
        int columns = dataGrid.getColumns();
        int rest = columns - cell;
        for (int i = 0; i < rest; ++i) {
            writer.startElement("td", (UIComponent)dataGrid);
            writer.writeAttribute("class", (Object)"rf-dg-c", null);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    @Override
    public DataVisitResult process(FacesContext facesContext, Object rowKey, Object argument) {
        RowHolderBase holder = (RowHolderBase)argument;
        Row row = holder.getRow();
        row.setRowKey(facesContext, rowKey);
        try {
            ResponseWriter writer = facesContext.getResponseWriter();
            this.encodeRow(writer, facesContext, holder);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        holder.nextCell();
        return DataVisitResult.CONTINUE;
    }

    @Override
    public void encodeFakeRow(FacesContext facesContext, RowHolderBase rowHolder) throws IOException {
        UIComponent component = (UIComponent)rowHolder.getRow();
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("tr", component);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.startElement("td", component);
        writer.endElement("td");
        writer.endElement("tr");
    }
}

