/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree;

import java.io.IOException;
import java.util.Collections;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import org.richfaces.javascript.JSFunction;
import org.richfaces.ui.iteration.tree.AbstractTreeNode;
import org.richfaces.ui.iteration.tree.TreeEncoderBase;
import org.richfaces.ui.iteration.tree.TreeRendererBase;
import org.richfaces.ui.iteration.tree.TreeRenderingContext;

class TreeEncoderPartial
extends TreeEncoderBase {
    protected final AbstractTreeNode treeNode;
    private Object rowKey;

    public TreeEncoderPartial(FacesContext context, AbstractTreeNode treeNode) {
        super(context, treeNode.findTreeComponent());
        this.treeNode = treeNode;
        this.rowKey = this.tree.getRowKey();
        if (this.rowKey == null) {
            throw new NullPointerException("rowKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode() throws IOException {
        String elementId = this.treeNode.getClientId(this.context);
        PartialResponseWriter prw = this.context.getPartialViewContext().getPartialResponseWriter();
        prw.startUpdate(elementId);
        Object clientEventHandlers = null;
        Object initialRowKey = this.tree.getRowKey();
        try {
            TreeRenderingContext.create(this.context, this.tree);
            this.tree.setRowKey(this.context, this.rowKey);
            this.encodeTree();
            prw.endUpdate();
            clientEventHandlers = TreeRenderingContext.get(this.context).getHandlers();
        }
        finally {
            try {
                this.tree.setRowKey(this.context, initialRowKey);
            }
            catch (Exception e) {
                TreeRendererBase.LOGGER.error(e.getMessage(), e);
            }
            TreeRenderingContext.delete(this.context);
        }
        prw.startEval();
        JSFunction function = new JSFunction("RichFaces.ui.TreeNode.initNodeByAjax", elementId, Collections.singletonMap("clientEventHandlers", clientEventHandlers));
        prw.write(function.toScript());
        prw.endEval();
    }
}

