/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree;

import org.richfaces.model.Range;
import org.richfaces.ui.common.SwitchType;
import org.richfaces.ui.iteration.tree.AbstractTree;

public class TreeRange
implements Range {
    private AbstractTree tree;
    private boolean traverseAll;

    public TreeRange(AbstractTree tree) {
        this.tree = tree;
        this.traverseAll = SwitchType.client == tree.getToggleType();
    }

    public boolean shouldProcessNode() {
        if (this.tree.getRowKey() == null) {
            return true;
        }
        return this.tree.findTreeNodeComponent() != null;
    }

    public boolean shouldIterateChildren() {
        if (this.tree.getRowKey() == null) {
            return true;
        }
        if (this.tree.isLeaf()) {
            return false;
        }
        return this.traverseAll || this.tree.isExpanded();
    }
}

