/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.menu.toolbar;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.ui.common.ComponentAttribute;
import org.richfaces.ui.menu.toolbar.AbstractToolbar;
import org.richfaces.ui.menu.toolbar.AbstractToolbarGroup;
import org.richfaces.util.HtmlDimensions;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(library="org.richfaces", name="menu/toolbar/toolbar.js"), @ResourceDependency(library="org.richfaces", name="menu/toolbar/toolbar.ecss")})
public abstract class ToolbarRendererBase
extends RendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.ToolbarRenderer";
    public static final Map<String, ComponentAttribute> ITEMS_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onclick").setEventNames("itemclick").setComponentAttributeName("onitemclick"), new ComponentAttribute("ondblclick").setEventNames("itemdblclick").setComponentAttributeName("onitemdblclick"), new ComponentAttribute("onmousedown").setEventNames("itemmousedown").setComponentAttributeName("onitemmousedown"), new ComponentAttribute("onmouseup").setEventNames("itemmouseup").setComponentAttributeName("onitemmouseup"), new ComponentAttribute("onmouseover").setEventNames("itemmouseover").setComponentAttributeName("onitemmouseover"), new ComponentAttribute("onmousemove").setEventNames("itemmousemove").setComponentAttributeName("onitemmousemove"), new ComponentAttribute("onmouseout").setEventNames("itemmouseout").setComponentAttributeName("onitemmouseout"), new ComponentAttribute("onkeypress").setEventNames("itemkeypress").setComponentAttributeName("onitemkeypress"), new ComponentAttribute("onkeydown").setEventNames("itemkeydown").setComponentAttributeName("onitemkeydown"), new ComponentAttribute("onkeyup").setEventNames("itemkeyup").setComponentAttributeName("onitemkeyup")));

    private void writeColElement(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("col", component);
        writer.writeAttribute("style", (Object)"width : 1px", null);
        writer.endElement("col");
    }

    private boolean isSeparatorFacetRendered(UIComponent component) {
        UIComponent separatorFacet = component.getFacet("itemSeparator");
        return separatorFacet != null ? separatorFacet.isRendered() : false;
    }

    private boolean isSeparatorAttributeRendered(UIComponent component) {
        String itemSeparator = (String)component.getAttributes().get("itemSeparator");
        return itemSeparator != null && itemSeparator.trim().length() != 0 && !itemSeparator.equalsIgnoreCase(ItemSeparators.NONE.toString());
    }

    private int getColumnCount(List<UIComponent> components) {
        int result = 0;
        for (UIComponent component : components) {
            if (component instanceof AbstractToolbarGroup) {
                result += component.getChildren().size();
                continue;
            }
            ++result;
        }
        return result;
    }

    private int getCountSeparators(AbstractToolbar toolBar, List<UIComponent> components) {
        int result = 0;
        if (components != null && (this.isSeparatorFacetRendered((UIComponent)toolBar) || this.isSeparatorAttributeRendered((UIComponent)toolBar))) {
            result += components.size() - 1;
        }
        for (UIComponent component : components) {
            if (!(component instanceof AbstractToolbarGroup)) continue;
            result += this.getCountSeparators((AbstractToolbarGroup)component, (List<UIComponent>)component.getChildren());
        }
        return result;
    }

    private int getCountSeparators(AbstractToolbarGroup toolBarGroup, List<UIComponent> components) {
        if (components != null && (this.isSeparatorFacetRendered((UIComponent)toolBarGroup) || this.isSeparatorAttributeRendered((UIComponent)toolBarGroup))) {
            return components.size() - 1;
        }
        return 0;
    }

    protected void renderColElements(FacesContext context, UIComponent component) throws IOException {
        int i;
        ResponseWriter writer = context.getResponseWriter();
        LinkedList<UIComponent> childrenToTheLeft = new LinkedList<UIComponent>();
        LinkedList<UIComponent> childrenToTheRight = new LinkedList<UIComponent>();
        this.getChildrenToLeftAndRight(context, component, childrenToTheLeft, childrenToTheRight);
        int columnAmount = this.getCountSeparators((AbstractToolbar)component, childrenToTheLeft) + this.getColumnCount(childrenToTheLeft);
        for (i = 0; i < columnAmount; ++i) {
            this.writeColElement(writer, component);
        }
        writer.startElement("col", component);
        writer.writeAttribute("style", (Object)"width : 100%", null);
        writer.endElement("col");
        columnAmount = this.getCountSeparators((AbstractToolbar)component, childrenToTheRight) + this.getColumnCount(childrenToTheRight);
        for (i = 0; i < columnAmount; ++i) {
            this.writeColElement(writer, component);
        }
    }

    private void getChildrenToLeftAndRight(FacesContext context, UIComponent component, List<UIComponent> childrenToTheLeft, List<UIComponent> childrenToTheRight) {
        AbstractToolbar toolbar = (AbstractToolbar)component;
        List children = toolbar.getChildren();
        if (children != null) {
            for (UIComponent child : children) {
                if (!child.isRendered()) continue;
                if (child instanceof AbstractToolbarGroup) {
                    AbstractToolbarGroup group = (AbstractToolbarGroup)child;
                    String location = group.getLocation();
                    if (location != null && location.equalsIgnoreCase(Locations.RIGHT.toString())) {
                        childrenToTheRight.add(child);
                        continue;
                    }
                    childrenToTheLeft.add(child);
                    continue;
                }
                childrenToTheLeft.add(child);
            }
        }
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        AbstractToolbar toolbar = (AbstractToolbar)component;
        String itemClass = (String)toolbar.getAttributes().get("itemClass");
        String itemStyle = (String)toolbar.getAttributes().get("itemStyle");
        List children = toolbar.getChildren();
        if (children != null) {
            UIComponent child;
            LinkedList<UIComponent> childrenToTheLeft = new LinkedList<UIComponent>();
            LinkedList<UIComponent> childrenToTheRight = new LinkedList<UIComponent>();
            this.getChildrenToLeftAndRight(context, component, childrenToTheLeft, childrenToTheRight);
            ResponseWriter writer = context.getResponseWriter();
            Iterator it = childrenToTheLeft.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                if (!(child instanceof AbstractToolbarGroup)) {
                    writer.startElement("td", component);
                    writer.writeAttribute("id", (Object)this.encodeClientItemID(child), null);
                    writer.writeAttribute("class", (Object)this.concatClasses("rf-tb-itm", itemClass), null);
                    if (this.isPropertyRendered(itemStyle)) {
                        writer.writeAttribute("style", (Object)itemStyle, null);
                    }
                }
                child.encodeAll(context);
                if (!(child instanceof AbstractToolbarGroup)) {
                    writer.endElement("td");
                }
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(context, (UIComponent)toolbar, writer);
            }
            writer.startElement("td", component);
            writer.writeAttribute("class", (Object)this.concatClasses("rf-tb-emp", itemClass), null);
            writer.writeText((Object)"\u00a0", null);
            writer.endElement("td");
            it = childrenToTheRight.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                child.encodeAll(context);
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(context, (UIComponent)toolbar, writer);
            }
        }
    }

    protected void insertSeparatorIfNeed(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        boolean isSeparatorFacetRendered;
        UIComponent separatorFacet = component.getFacet("itemSeparator");
        boolean bl = isSeparatorFacetRendered = separatorFacet != null ? separatorFacet.isRendered() : false;
        if (isSeparatorFacetRendered) {
            writer.startElement("td", component);
            writer.writeAttribute("class", (Object)"rf-tb-sep", null);
            separatorFacet.encodeAll(context);
            writer.endElement("td");
        } else {
            this.insertDefaultSeparatorIfNeed(context, component, writer);
        }
    }

    protected void insertDefaultSeparatorIfNeed(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String itemSeparator = (String)component.getAttributes().get("itemSeparator");
        if (itemSeparator != null && itemSeparator.trim().length() != 0 && !itemSeparator.equalsIgnoreCase(ItemSeparators.NONE.toString())) {
            ItemSeparators separator = null;
            if (itemSeparator.equalsIgnoreCase(ItemSeparators.SQUARE.toString())) {
                separator = ItemSeparators.SQUARE;
            } else if (itemSeparator.equalsIgnoreCase(ItemSeparators.DISC.toString())) {
                separator = ItemSeparators.DISC;
            } else if (itemSeparator.equalsIgnoreCase(ItemSeparators.GRID.toString())) {
                separator = ItemSeparators.GRID;
            } else if (itemSeparator.equalsIgnoreCase(ItemSeparators.LINE.toString())) {
                separator = ItemSeparators.LINE;
            }
            writer.startElement("td", component);
            String separatorClass = "rf-tb-sep";
            separatorClass = this.concatClasses(separatorClass, (String)component.getAttributes().get("separatorClass"));
            writer.writeAttribute("class", (Object)separatorClass, null);
            if (separator != null) {
                String itemSeparatorClass = "rf-tb-sep-" + separator.toString().toLowerCase();
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)itemSeparatorClass, null);
                writer.writeText((Object)"\u00a0", null);
                writer.endElement("div");
            } else {
                String uri = RenderKitUtils.getResourceURL(itemSeparator, context);
                writer.startElement("img", component);
                writer.writeAttribute("src", (Object)uri, null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.endElement("img");
            }
            writer.endElement("td");
        }
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractToolbar.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean isPropertyRendered(String property) {
        return null != property && !"".equals(property);
    }

    protected String getWidthToolbar(UIComponent component) {
        if (component instanceof AbstractToolbar) {
            String width = ((AbstractToolbar)component).getWidth();
            if (width == null || width.length() == 0) {
                return "100%";
            }
            return HtmlDimensions.formatSize(width);
        }
        return "";
    }

    protected String getHeightToolbar(UIComponent component) {
        if (component instanceof AbstractToolbar) {
            return HtmlDimensions.formatSize(((AbstractToolbar)component).getHeight());
        }
        return "";
    }

    protected Map<String, Object> getOptions(UIComponent component) {
        if (component == null) {
            return null;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (component instanceof AbstractToolbar) {
            HashMap<String, Object> tbEvents = new HashMap<String, Object>();
            for (ComponentAttribute componentAttribute : ITEMS_HANDLER_ATTRIBUTES.values()) {
                Object attr = component.getAttributes().get(componentAttribute.getComponentAttributeName());
                if (attr == null) continue;
                RenderKitUtils.addToScriptHash(tbEvents, componentAttribute.getHtmlAttributeName().substring(2), attr, null, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
            }
            results.put("id", component.getClientId());
            results.put("events", tbEvents);
            List<AbstractToolbarGroup> groups = this.getToolBarGroups((AbstractToolbar)component);
            LinkedList tbgListOptions = new LinkedList();
            for (AbstractToolbarGroup tbg : groups) {
                HashMap<String, Cloneable> tbgOptions = new HashMap<String, Cloneable>();
                HashMap<String, Object> tbgEvents = new HashMap<String, Object>();
                LinkedList<String> tbgIDs = new LinkedList<String>();
                for (UIComponent comp : tbg.getChildren()) {
                    tbgIDs.add(this.encodeClientItemID(comp));
                }
                for (ComponentAttribute componentAttribute : ITEMS_HANDLER_ATTRIBUTES.values()) {
                    Object attr = tbg.getAttributes().get(componentAttribute.getComponentAttributeName());
                    if (attr == null) continue;
                    RenderKitUtils.addToScriptHash(tbgEvents, componentAttribute.getHtmlAttributeName().substring(2), attr, null, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
                }
                if (tbgEvents.isEmpty()) continue;
                tbgOptions.put("events", tbgEvents);
                tbgOptions.put("ids", tbgIDs);
                tbgListOptions.add(tbgOptions);
            }
            results.put("groups", tbgListOptions);
        }
        return results;
    }

    protected String encodeClientItemID(UIComponent component) {
        return component != null ? component.getClientId() + "_itm" : "";
    }

    private List<AbstractToolbarGroup> getToolBarGroups(AbstractToolbar toolBar) {
        LinkedList<AbstractToolbarGroup> list = new LinkedList<AbstractToolbarGroup>();
        if (toolBar != null) {
            for (UIComponent comp : toolBar.getChildren()) {
                if (!(comp instanceof AbstractToolbarGroup)) continue;
                list.add((AbstractToolbarGroup)comp);
            }
        }
        return list;
    }

    public static enum Locations {
        RIGHT,
        LEFT;

    }

    public static enum ItemSeparators {
        NONE,
        SQUARE,
        DISC,
        GRID,
        LINE;

    }
}

