/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.focus;

import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.ui.common.AjaxOutput;
import org.richfaces.ui.misc.focus.FocusRendererInterface;
import org.richfaces.util.RendererUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractFocus
extends UIOutput
implements AjaxOutput {
    public static final String COMPONENT_TYPE = "org.richfaces.Focus";
    public static final String COMPONENT_FAMILY = "org.richfaces.Focus";

    @Override
    @Attribute(defaultValue="true")
    public abstract boolean isAjaxRendered();

    @Attribute(defaultValue="true")
    public abstract boolean isValidationAware();

    @Attribute(defaultValue="false")
    public abstract boolean isPreserve();

    @Attribute(defaultValue="false")
    public abstract boolean isDelayed();

    @Override
    @Attribute(hidden=true)
    public abstract boolean isKeepTransient();

    public Mode getMode() {
        UIForm form = (UIForm)RendererUtils.getInstance().getNestingForm((UIComponent)this);
        if (form == null) {
            return Mode.VIEW;
        }
        return Mode.FORM;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event.getSource() == this && event instanceof PostAddToViewEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            FocusRendererInterface renderer = (FocusRendererInterface)context.getRenderKit().getRenderer("org.richfaces.Focus", "org.richfaces.FocusRenderer");
            renderer.postAddToView(context, this);
        }
        super.processEvent(event);
    }

    public static enum Mode {
        FORM,
        VIEW;

    }
}

