/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.toggle.togglePanel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.javascript.JSFunctionDefinition;
import org.richfaces.javascript.JSObject;
import org.richfaces.javascript.JSReference;
import org.richfaces.ui.behavior.HandlersChain;
import org.richfaces.ui.common.AjaxOptions;
import org.richfaces.ui.common.DivPanelRenderer;
import org.richfaces.ui.common.meta.MetaComponentRenderer;
import org.richfaces.ui.toggle.AbstractTogglePanelItemInterface;
import org.richfaces.ui.toggle.TogglePanelVisitCallback;
import org.richfaces.ui.toggle.TogglePanelVisitState;
import org.richfaces.ui.toggle.togglePanel.AbstractTogglePanel;
import org.richfaces.util.AjaxRendererUtils;
import org.richfaces.util.FormUtil;
import org.richfaces.util.HtmlUtil;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="toggle/togglePanel/togglePanel.js")})
public class TogglePanelRenderer
extends DivPanelRenderer
implements MetaComponentRenderer {
    public static final String VALUE_POSTFIX = "-value";
    protected static final String ITEM_CHANGE = "itemchange";
    protected static final String BEFORE_ITEM_CHANGE = "beforeitemchange";
    private static final String ON = "on";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(TogglePanelRenderer.getValueRequestParamName(context, component));
        if (newValue != null) {
            panel.setSubmittedActiveItem(newValue);
            if (this.isSubmitted(context, panel)) {
                PartialViewContext pvc = context.getPartialViewContext();
                pvc.getRenderIds().add(component.getClientId(context) + '@' + "activeItem");
            }
        }
    }

    protected boolean isSubmitted(FacesContext context, AbstractTogglePanel panel) {
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        return parameterMap.get(panel.getClientId(context)) != null;
    }

    public static String getValueRequestParamName(FacesContext context, UIComponent component) {
        return component.getClientId(context) + VALUE_POSTFIX;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        FormUtil.throwEnclFormReqExceptionIfNeed(context, component);
        super.doEncodeBegin(writer, context, component);
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)TogglePanelRenderer.getValueRequestParamName(context, component), null);
        writer.writeAttribute("name", (Object)TogglePanelRenderer.getValueRequestParamName(context, component), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)panel.getActiveItem(), null);
        writer.endElement("input");
        this.writeJavaScript(writer, context, component);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-tgp", TogglePanelRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TogglePanel", component.getClientId(context), this.getScriptObjectOptions(context, component));
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("activeItem", panel.getActiveItem());
        options.put("cycledSwitching", panel.isCycledSwitching());
        options.put("ajax", TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panel));
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, ITEM_CHANGE);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, BEFORE_ITEM_CHANGE);
        return options;
    }

    public static void addEventOption(FacesContext context, UIComponent component, Map<String, Object> options, String eventName) {
        HandlersChain handlersChain = new HandlersChain(context, component);
        handlersChain.addInlineHandlerFromAttribute(ON + eventName);
        handlersChain.addBehaviors(eventName);
        String handler = handlersChain.toScript();
        if (handler != null) {
            options.put(ON + eventName, new JSFunctionDefinition(JSReference.EVENT).addToBody(handler));
        }
    }

    public static AjaxOptions getAjaxOptions(FacesContext context, UIComponent panel) {
        return AjaxRendererUtils.buildEventOptions(context, panel);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanel.class;
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("activeItem".equals(metaComponentId)) {
            AbstractTogglePanel panel = (AbstractTogglePanel)component;
            int itemIndex = panel.getIndexByName(panel.getActiveItem());
            if (itemIndex >= 0) {
                this.encodeActiveItem(panel, itemIndex);
            } else {
                this.partialStart(context, component.getClientId(context));
                component.encodeAll(context);
                this.partialEnd(context);
                this.addOnCompleteParam(context, panel.getActiveItem(), panel.getClientId(context));
            }
        } else {
            throw new IllegalArgumentException(metaComponentId);
        }
    }

    private String encodeActiveItem(final AbstractTogglePanel panel, final int activeIndex) {
        panel.visitTogglePanelItems(panel, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext context, TogglePanelVisitState visitState) {
                if (activeIndex == visitState.getCount()) {
                    AbstractTogglePanelItemInterface item = visitState.getItem();
                    String itemName = item.getName();
                    try {
                        TogglePanelRenderer.this.partialStart(context, ((UIComponent)item).getClientId(context));
                        ((UIComponent)item).encodeAll(context);
                        TogglePanelRenderer.this.partialEnd(context);
                        TogglePanelRenderer.this.addOnCompleteParam(context, itemName, panel.getClientId(context));
                    }
                    catch (IOException e) {
                        throw new FacesException((Throwable)e);
                    }
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return null;
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
    }

    protected void partialStart(FacesContext facesContext, String id) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(id);
    }

    protected void partialEnd(FacesContext facesContext) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
    }
}

