/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SSEAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;

    private void writePadding(AtmosphereResponse response) {
        if (response.request() != null && response.request().getAttribute("paddingWritten") != null) {
            return;
        }
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("utf-8");
        boolean isUsingStream = (Boolean)response.request().getAttribute("org.atmosphere.useStream");
        if (isUsingStream) {
            ServletOutputStream stream = null;
            try {
                stream = response.getOutputStream();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            try {
                stream.write(padding);
                stream.flush();
            }
            catch (IOException ex) {
                logger.warn("SSE may not work", (Throwable)ex);
            }
        } else {
            PrintWriter w = null;
            try {
                w = response.getWriter();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            w.println(paddingText);
            w.flush();
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE)) {
            super.inspect(r);
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    SSEAtmosphereInterceptor.this.writePadding(response);
                }
            });
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptor(){

                    private void padding() {
                        if (!r.isSuspended()) {
                            SSEAtmosphereInterceptor.this.writePadding(response);
                            r.getRequest().setAttribute("paddingWritten", "true");
                        }
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        this.padding();
                        response2.write("data:");
                    }

                    @Override
                    public byte[] transformPayload(byte[] responseDraft, byte[] data) throws IOException {
                        return responseDraft;
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        response2.write("\n\n".getBytes());
                    }
                });
            } else {
                throw new IllegalStateException("AsyncIOWriter must be an instance of " + AsyncIOWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "SSE Interceptor Support";
    }

    static {
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 2000; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }
}

