package org.richfaces.ui.misc.hotKey;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.misc.hotKey.HotKeyRendererBase;


public class HotKeyRenderer extends HotKeyRendererBase {
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH35 = attributes()
	     .generic("key","key")
	     

	     .generic("enabledInInput","enabledInInput")
	     .defaultValue(false)

	     .generic("preventDefault","preventDefault")
	     .defaultValue(true)
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH36 = attributes()
	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter();
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","display: none;",null);


responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH35, null);
addToScriptHash(options, "selector", this.getEscapedSelector(facesContext,component), null, null);


	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH36, ScriptHashVariableWrapper.eventHandler);

{
	Object text = "new RichFaces.ui.HotKey(\"" + convertToString(clientId) + "\",  " + convertToString(toScriptArgs(options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
}

