/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

public enum ServletVersion {
    SERVLET_2_5,
    SERVLET_3_0;

    private static final ServletVersion CURRENT_VERSION;

    private static ServletVersion detectVersion() {
        try {
            Class.forName("javax.servlet.http.Part");
            return SERVLET_3_0;
        }
        catch (ClassNotFoundException e1) {
            return SERVLET_2_5;
        }
    }

    public static ServletVersion getCurrent() {
        return CURRENT_VERSION;
    }

    public boolean isCompliantWith(ServletVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("version must be provided");
        }
        return this.ordinal() >= version.ordinal();
    }

    static {
        CURRENT_VERSION = ServletVersion.detectVersion();
    }
}

