/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.richfaces.context.AjaxDataSerializer;
import org.richfaces.context.ExecuteComponentCallback;
import org.richfaces.context.ExecuteExtendedVisitContext;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.context.PartialResponseWriterWrapper;
import org.richfaces.context.PartialViewContextAjaxOutputTracker;
import org.richfaces.context.PartialViewExecuteVisitCallback;
import org.richfaces.context.PartialViewRenderVisitCallback;
import org.richfaces.context.RenderComponentCallback;
import org.richfaces.context.RenderExtendedVisitContext;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.javascript.ScriptsHolder;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.services.ServiceTracker;
import org.richfaces.util.AjaxRendererUtils;
import org.richfaces.util.FastJoiner;

public class ExtendedPartialViewContextImpl
extends ExtendedPartialViewContext {
    private static final Logger LOG = RichfacesLogger.CONTEXT.getLogger();
    private static final String ORIGINAL_WRITER = "org.richfaces.PartialViewContextImpl.ORIGINAL_WRITER";
    private static final String EXTENSION_ID = "org.richfaces.extension";
    private static final String BEFOREDOMUPDATE_ELEMENT_NAME = "beforedomupdate";
    private static final String COMPLETE_ELEMENT_NAME = "complete";
    private static final String RENDER_ELEMENT_NAME = "render";
    private static final String DATA_ELEMENT_NAME = "data";
    private static final String COMPONENT_DATA_ELEMENT_NAME = "componentData";
    private static final FastJoiner SPACE_JOINER = FastJoiner.on(' ');
    private ContextMode contextMode = null;
    private Collection<String> executeIds = null;
    private Collection<String> renderIds = null;
    private Collection<String> componentRenderIds = null;
    private Boolean renderAll = null;
    private String activatorComponentId = null;
    private String behaviorEvent = null;
    private boolean released = false;
    private boolean limitRender = false;
    private PartialViewContext wrappedViewContext;
    private PartialResponseWriter partialResponseWriter;
    private String onbeforedomupdate;
    private String oncomplete;
    private Object responseData;

    public ExtendedPartialViewContextImpl(PartialViewContext wrappedViewContext, FacesContext facesContext) {
        super(facesContext);
        this.wrappedViewContext = wrappedViewContext;
    }

    public PartialViewContext getWrapped() {
        return this.wrappedViewContext;
    }

    public void processPartial(PhaseId phaseId) {
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (phaseId == PhaseId.RENDER_RESPONSE) {
                this.processPartialRenderPhase();
            } else if (this.isProcessedExecutePhase(phaseId)) {
                this.processPartialExecutePhase(phaseId);
            }
        } else {
            this.wrappedViewContext.processPartial(phaseId);
        }
    }

    private boolean isProcessedExecutePhase(PhaseId phaseId) {
        return phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES;
    }

    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.executeIds == null) {
                this.executeIds = new LinkedHashSet<String>();
                this.visitActivatorAtExecute();
            }
            return this.executeIds;
        }
        return this.wrappedViewContext.getExecuteIds();
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.renderIds == null) {
                this.renderIds = new LinkedHashSet<String>();
            }
            return this.renderIds;
        }
        return this.wrappedViewContext.getRenderIds();
    }

    public boolean isExecuteAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            return this.getExecuteIds().contains("@all");
        }
        return this.wrappedViewContext.isExecuteAll();
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.renderAll != null) {
                return this.renderAll;
            }
            return this.getRenderIds().contains("@all");
        }
        return this.wrappedViewContext.isRenderAll();
    }

    public void setRenderAll(boolean isRenderAll) {
        this.assertNotReleased();
        this.renderAll = isRenderAll;
        super.setRenderAll(this.renderAll.booleanValue());
    }

    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this.partialResponseWriter == null) {
            this.partialResponseWriter = new ExtensionWritingPartialResponseWriter(this.wrappedViewContext.getPartialResponseWriter());
        }
        return this.partialResponseWriter;
    }

    protected void processPartialExecutePhase(PhaseId phaseId) {
        FacesContext facesContext = this.getFacesContext();
        PartialViewContext pvc = facesContext.getPartialViewContext();
        Collection executeIds = pvc.getExecuteIds();
        if (executeIds == null || executeIds.isEmpty()) {
            return;
        }
        try {
            this.executeComponents(phaseId, executeIds);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            ExternalContext externalContext = facesContext.getExternalContext();
            externalContext.setResponseCharacterEncoding(externalContext.getRequestCharacterEncoding());
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            facesContext.setResponseWriter((ResponseWriter)writer);
        }
    }

    protected void executeComponents(PhaseId phaseId, Collection<String> executeIds) {
        FacesContext facesContext = this.getFacesContext();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        ExecuteExtendedVisitContext visitContext = new ExecuteExtendedVisitContext(facesContext, executeIds, hints);
        PartialViewExecuteVisitCallback callback = new PartialViewExecuteVisitCallback(facesContext, phaseId);
        facesContext.getViewRoot().visitTree((VisitContext)visitContext, (VisitCallback)callback);
    }

    protected void processPartialRenderPhase() {
        FacesContext facesContext = this.getFacesContext();
        PartialViewContext pvc = facesContext.getPartialViewContext();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Collection renderIds = pvc.getRenderIds();
        this.visitActivatorAtRender(renderIds);
        try {
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            ResponseWriter orig = facesContext.getResponseWriter();
            facesContext.getAttributes().put(ORIGINAL_WRITER, orig);
            facesContext.setResponseWriter((ResponseWriter)writer);
            ExternalContext exContext = facesContext.getExternalContext();
            exContext.setResponseContentType("text/xml");
            exContext.addResponseHeader("Cache-Control", "no-cache");
            writer.startDocument();
            if (this.isRenderAll()) {
                this.renderAll(facesContext, viewRoot);
                this.renderState(facesContext);
            } else {
                if (renderIds != null && !renderIds.isEmpty() || !this.limitRender && PartialViewContextAjaxOutputTracker.hasNestedAjaxOutputs((UIComponent)viewRoot)) {
                    EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
                    RenderExtendedVisitContext visitContext = new RenderExtendedVisitContext(facesContext, (Collection<String>)renderIds, hints, this.limitRender);
                    PartialViewRenderVisitCallback visitCallback = new PartialViewRenderVisitCallback(facesContext);
                    viewRoot.visitTree((VisitContext)visitContext, (VisitCallback)visitCallback);
                }
                this.renderState(facesContext);
            }
            writer.endDocument();
        }
        catch (IOException ex) {
            this.cleanupAfterView();
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            this.cleanupAfterView();
            throw ex;
        }
    }

    private void visitActivatorAtExecute() {
        ExecuteComponentCallback callback = new ExecuteComponentCallback(this.getFacesContext(), this.behaviorEvent);
        if (this.visitActivatorComponent(this.activatorComponentId, callback, EnumSet.noneOf(VisitHint.class))) {
            this.setupExecuteCallbackData(callback);
            if (!this.executeIds.contains("@all")) {
                this.addImplicitExecuteIds(this.executeIds);
            }
        }
    }

    private void setupRenderCallbackData(RenderComponentCallback callback) {
        this.componentRenderIds = callback.getRenderIds();
        this.onbeforedomupdate = callback.getOnbeforedomupdate();
        this.oncomplete = callback.getOncomplete();
        this.responseData = callback.getData();
        this.limitRender = callback.isLimitRender();
    }

    private void setupExecuteCallbackData(ExecuteComponentCallback callback) {
        this.executeIds.addAll(callback.getExecuteIds());
        this.setupRenderCallbackData(callback);
    }

    private void visitActivatorAtRender(Collection<String> ids) {
        if (!this.isRenderAll()) {
            RenderComponentCallback callback = new RenderComponentCallback(this.getFacesContext(), this.behaviorEvent);
            if (this.visitActivatorComponent(this.activatorComponentId, callback, EnumSet.noneOf(VisitHint.class))) {
                this.setupRenderCallbackData(callback);
            }
            if (this.componentRenderIds != null) {
                ids.addAll(this.componentRenderIds);
            }
            if (!Boolean.TRUE.equals(this.renderAll) && !ids.contains("@all")) {
                this.addImplicitRenderIds(ids, this.limitRender);
                this.appendOnbeforedomupdate(this.onbeforedomupdate);
                this.appendOncomplete(this.oncomplete);
                this.setResponseData(this.responseData);
            }
        }
    }

    private void renderAll(FacesContext context, UIViewRoot viewRoot) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewRoot");
        if (viewRoot.getChildCount() > 0) {
            for (UIComponent child : viewRoot.getChildren()) {
                child.encodeAll(context);
            }
        }
        writer.endUpdate();
    }

    private void renderState(FacesContext context) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        String viewStateId = AjaxRendererUtils.getViewStateId(context);
        writer.startUpdate(viewStateId);
        String state = context.getApplication().getStateManager().getViewState(context);
        writer.write(state);
        writer.endUpdate();
    }

    @Override
    public void release() {
        super.release();
        this.assertNotReleased();
        this.released = true;
        this.wrappedViewContext.release();
        this.wrappedViewContext = null;
        this.renderAll = null;
        this.executeIds = null;
        this.renderIds = null;
        this.limitRender = false;
        this.activatorComponentId = null;
        this.behaviorEvent = null;
        this.contextMode = null;
    }

    protected void addImplicitExecuteIds(Collection<String> ids) {
        UIViewRoot root;
        if (!ids.isEmpty() && (root = this.getFacesContext().getViewRoot()).getFacetCount() > 0 && root.getFacet("javax_faces_metadata") != null) {
            ids.add("javax_faces_metadata");
        }
    }

    protected void addImplicitRenderIds(Collection<String> ids, boolean limitRender) {
    }

    protected void addJavaScriptServicePageScripts(FacesContext context) {
        ScriptsHolder scriptsHolder = ServiceTracker.getService(JavaScriptService.class).getScriptsHolder(context);
        StringBuilder scripts = new StringBuilder();
        for (Object script : scriptsHolder.getScripts()) {
            scripts.append(ScriptUtils.toScript(script));
            scripts.append(";");
        }
        for (Object script : scriptsHolder.getPageReadyScripts()) {
            scripts.append(ScriptUtils.toScript(script));
            scripts.append(";");
        }
        if (scripts.length() > 0) {
            scripts.append("RichFaces.javascriptServiceComplete();");
            this.prependOncomplete(scripts.toString());
        }
    }

    protected void renderExtensions(FacesContext context, UIComponent component) throws IOException {
        Map<String, Object> responseComponentDataMap;
        Object responseData;
        String string;
        Object oncomplete;
        String string2;
        ExtendedPartialViewContext partialContext = ExtendedPartialViewContext.getInstance(context);
        Map<String, String> attributes = Collections.singletonMap("id", context.getExternalContext().encodeNamespace(EXTENSION_ID));
        PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
        boolean[] writingState = new boolean[]{false};
        Object onbeforedomupdate = partialContext.getOnbeforedomupdate();
        if (onbeforedomupdate != null && (string2 = onbeforedomupdate.toString()).length() != 0) {
            ExtendedPartialViewContextImpl.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(BEFOREDOMUPDATE_ELEMENT_NAME, component);
            writer.writeText(onbeforedomupdate, null);
            writer.endElement(BEFOREDOMUPDATE_ELEMENT_NAME);
        }
        if ((oncomplete = partialContext.getOncomplete()) != null && (string = oncomplete.toString()).length() != 0) {
            ExtendedPartialViewContextImpl.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPLETE_ELEMENT_NAME, component);
            writer.writeText(oncomplete, null);
            writer.endElement(COMPLETE_ELEMENT_NAME);
        }
        if (!partialContext.getRenderIds().isEmpty()) {
            String renderIds = SPACE_JOINER.join(partialContext.getRenderIds());
            ExtendedPartialViewContextImpl.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(RENDER_ELEMENT_NAME, component);
            writer.writeText((Object)renderIds, null);
            writer.endElement(RENDER_ELEMENT_NAME);
        }
        if ((responseData = partialContext.getResponseData()) != null) {
            ExtendedPartialViewContextImpl.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(DATA_ELEMENT_NAME, component);
            AjaxDataSerializer serializer = ServiceTracker.getService(context, AjaxDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseData), null);
            writer.endElement(DATA_ELEMENT_NAME);
        }
        if ((responseComponentDataMap = partialContext.getResponseComponentDataMap()) != null && !responseComponentDataMap.isEmpty()) {
            ExtendedPartialViewContextImpl.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPONENT_DATA_ELEMENT_NAME, component);
            AjaxDataSerializer serializer = ServiceTracker.getService(context, AjaxDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseComponentDataMap), null);
            writer.endElement(COMPONENT_DATA_ELEMENT_NAME);
        }
        ExtendedPartialViewContextImpl.endExtensionElementIfNecessary(writer, writingState);
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException("PartialViewContext already released!");
        }
    }

    private boolean visitActivatorComponent(String componentActivatorId, VisitCallback visitCallback, Set<VisitHint> visitHints) {
        FacesContext facesContext = this.getFacesContext();
        Set<String> idsToVisit = Collections.singleton(componentActivatorId);
        ExecuteExtendedVisitContext visitContext = new ExecuteExtendedVisitContext(facesContext, idsToVisit, visitHints);
        boolean visitResult = facesContext.getViewRoot().visitTree((VisitContext)visitContext, visitCallback);
        return visitResult;
    }

    private void cleanupAfterView() {
        FacesContext facesContext = this.getFacesContext();
        ResponseWriter orig = (ResponseWriter)facesContext.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        facesContext.setResponseWriter(orig);
    }

    protected ContextMode detectContextMode() {
        if (this.contextMode == null) {
            Map requestParameterMap = this.getFacesContext().getExternalContext().getRequestParameterMap();
            this.activatorComponentId = (String)requestParameterMap.get("org.richfaces.ajax.component");
            if (this.activatorComponentId != null) {
                this.contextMode = ContextMode.DIRECT;
                this.behaviorEvent = (String)requestParameterMap.get("javax.faces.behavior.event");
            } else {
                this.contextMode = ContextMode.WRAPPED;
            }
        }
        return this.contextMode;
    }

    private static void startExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, Map<String, String> attributes, boolean[] writingState) throws IOException {
        if (!writingState[0]) {
            writingState[0] = true;
            partialResponseWriter.startExtension(attributes);
        }
    }

    private static void endExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, boolean[] writingState) throws IOException {
        if (writingState[0]) {
            writingState[0] = false;
            partialResponseWriter.endExtension();
        }
    }

    private class ExtensionWritingPartialResponseWriter
    extends PartialResponseWriterWrapper {
        public ExtensionWritingPartialResponseWriter(PartialResponseWriter wrapped) {
            super(wrapped);
        }

        @Override
        public void endDocument() throws IOException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIViewRoot viewRoot = facesContext.getViewRoot();
            ExtendedPartialViewContextImpl.this.addJavaScriptServicePageScripts(facesContext);
            ExtendedPartialViewContextImpl.this.renderExtensions(facesContext, (UIComponent)viewRoot);
            super.endDocument();
        }
    }

    private static enum ContextMode {
        WRAPPED,
        DIRECT;

    }
}

