/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.richfaces.ui.common.AjaxOutput;

public class PartialViewContextAjaxOutputTracker
implements SystemEventListener {
    private static final String ATTRIBUTE_NAME = "org.richfaces.AjaxOutputTracker";

    private static Set<String> getTrackedChildrenSet(UIComponent component, boolean create) {
        Map attributes = component.getAttributes();
        HashSet trackedChildrenSet = (HashSet)attributes.get(ATTRIBUTE_NAME);
        if (trackedChildrenSet == null && create) {
            trackedChildrenSet = new HashSet();
            attributes.put(ATTRIBUTE_NAME, trackedChildrenSet);
        }
        return trackedChildrenSet;
    }

    private static void clearTrackedChildrenSet(UIComponent component) {
        component.getAttributes().remove(ATTRIBUTE_NAME);
    }

    static Collection<String> getDirectChildrenIds(UIComponent component) {
        if (!PartialViewContextAjaxOutputTracker.isContainerComponent(component)) {
            throw new IllegalArgumentException(component.toString());
        }
        return PartialViewContextAjaxOutputTracker.getTrackedChildrenSet(component, false);
    }

    static boolean hasNestedAjaxOutputs(UIComponent component) {
        Collection<String> childrenIds = PartialViewContextAjaxOutputTracker.getDirectChildrenIds(component);
        return childrenIds != null && !childrenIds.isEmpty();
    }

    private static String getId(UIComponent component) {
        String id = component.getId();
        if (id == null) {
            component.getClientId();
            id = component.getId();
        }
        return id;
    }

    private static boolean isContainerComponent(UIComponent component) {
        return component instanceof NamingContainer || component instanceof UIViewRoot;
    }

    private UIComponent findParentContainerComponent(UIComponent component) {
        UIComponent c;
        for (c = component.getParent(); c != null && !PartialViewContextAjaxOutputTracker.isContainerComponent(c); c = c.getParent()) {
        }
        return c;
    }

    private void componentAdded(UIComponent c) {
        UIComponent parent;
        UIComponent child = c;
        while ((parent = this.findParentContainerComponent(child)) != null) {
            Set<String> trackedChildrenSet = PartialViewContextAjaxOutputTracker.getTrackedChildrenSet(parent, true);
            boolean updateNextParent = trackedChildrenSet.isEmpty();
            trackedChildrenSet.add(PartialViewContextAjaxOutputTracker.getId(child));
            if (!updateNextParent) break;
            child = parent;
        }
    }

    private void componentRemoved(UIComponent c) {
        UIComponent parent;
        UIComponent child = c;
        while ((parent = this.findParentContainerComponent(child)) != null) {
            Set<String> trackingSet = PartialViewContextAjaxOutputTracker.getTrackedChildrenSet(parent, false);
            if (trackingSet != null) {
                trackingSet.remove(PartialViewContextAjaxOutputTracker.getId(child));
                if (!trackingSet.isEmpty()) break;
                PartialViewContextAjaxOutputTracker.clearTrackedChildrenSet(parent);
            }
            child = parent;
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostAddToViewEvent) {
            PostAddToViewEvent addToViewEvent = (PostAddToViewEvent)event;
            this.componentAdded(addToViewEvent.getComponent());
        } else if (event instanceof PreRemoveFromViewEvent) {
            PreRemoveFromViewEvent removeFromViewEvent = (PreRemoveFromViewEvent)event;
            this.componentRemoved(removeFromViewEvent.getComponent());
        } else {
            throw new IllegalArgumentException(event.toString());
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof AjaxOutput;
    }
}

