/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.richfaces.ui.common.meta.MetaComponentProcessor;

final class PartialViewExecuteVisitCallback
implements VisitCallback {
    private FacesContext facesContext;
    private PhaseId phaseId;

    PartialViewExecuteVisitCallback(FacesContext context, PhaseId phaseId) {
        this.facesContext = context;
        this.phaseId = phaseId;
    }

    public VisitResult visit(VisitContext context, UIComponent target) {
        String metaComponentId = (String)this.facesContext.getAttributes().get("org.richfaces.MetaComponentId");
        if (metaComponentId != null) {
            MetaComponentProcessor executor = (MetaComponentProcessor)target;
            executor.processMetaComponent(this.facesContext, metaComponentId);
        } else if (this.phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            target.processDecodes(this.facesContext);
        } else if (this.phaseId == PhaseId.PROCESS_VALIDATIONS) {
            target.processValidators(this.facesContext);
        } else if (this.phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            target.processUpdates(this.facesContext);
        } else {
            throw new IllegalArgumentException(this.phaseId.toString());
        }
        return VisitResult.REJECT;
    }
}

