/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.ui.common.meta.MetaComponentEncoder;

final class PartialViewRenderVisitCallback
implements VisitCallback {
    private static final Logger LOG = RichfacesLogger.CONTEXT.getLogger();
    private FacesContext ctx;

    PartialViewRenderVisitCallback(FacesContext ctx) {
        this.ctx = ctx;
    }

    private void logException(Exception e) {
        if (LOG.isErrorEnabled()) {
            LOG.error(e.getMessage(), e);
        }
    }

    public VisitResult visit(VisitContext context, UIComponent target) {
        String metaComponentId = (String)this.ctx.getAttributes().get("org.richfaces.MetaComponentId");
        if (metaComponentId != null) {
            MetaComponentEncoder encoder = (MetaComponentEncoder)target;
            try {
                encoder.encodeMetaComponent(this.ctx, metaComponentId);
            }
            catch (Exception e) {
                this.logException(e);
            }
        } else {
            PartialResponseWriter writer = this.ctx.getPartialViewContext().getPartialResponseWriter();
            try {
                writer.startUpdate(target.getClientId(this.ctx));
                try {
                    target.encodeAll(this.ctx);
                }
                catch (Exception ce) {
                    this.logException(ce);
                }
                writer.endUpdate();
            }
            catch (IOException e) {
                this.logException(e);
            }
        }
        return VisitResult.REJECT;
    }
}

