/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el;

import com.google.common.primitives.Primitives;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.richfaces.el.ConstantValueExpression;

public final class ELUtils {
    private ELUtils() {
    }

    public static boolean isValueReference(String value) {
        int end;
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        return start >= 0 && (end = value.lastIndexOf(125)) >= 0 && start < end;
    }

    public static ValueExpression createValueExpression(String expression) {
        return ELUtils.createValueExpression(expression, Object.class);
    }

    public static ValueExpression createValueExpression(String expression, Class<?> expectedType) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
    }

    public static Object evaluateValueExpression(ValueExpression expression, ELContext elContext) {
        if (expression.isLiteralText()) {
            return expression.getExpressionString();
        }
        return expression.getValue(elContext);
    }

    public static ValueExpression createValueExpression(FacesContext context, String expression, boolean literal, Class<?> expectedType) {
        ConstantValueExpression result = null;
        if (!literal && ELUtils.isValueReference(expression)) {
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            if (expressionFactory == null) {
                throw new IllegalStateException("ExpressionFactory is null");
            }
            result = expressionFactory.createValueExpression(context.getELContext(), expression, expectedType);
        } else {
            Object coercedValue = ELUtils.coerce(expression, expectedType);
            if (coercedValue != null) {
                result = new ConstantValueExpression(coercedValue);
            }
        }
        return result;
    }

    public static <T> T coerce(Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return targetType.cast(value);
        }
        if (value instanceof String) {
            PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
            if (editor == null && Primitives.isWrapperType(targetType)) {
                editor = PropertyEditorManager.findEditor(Primitives.unwrap(targetType));
            }
            if (editor != null) {
                editor.setAsText((String)value);
                return targetType.cast(editor.getValue());
            }
            if (targetType.isEnum()) {
                return targetType.cast(Enum.valueOf(targetType, (String)value));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot convert {0} to object of {1} type", value, targetType.getName()));
    }
}

