/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fileUpload;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FacesContextWrapper;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.richfaces.ServletVersion;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.request.BaseMultipartRequest;
import org.richfaces.request.MultipartRequest;
import org.richfaces.request.MultipartRequest25;
import org.richfaces.request.MultipartRequest30;
import org.richfaces.request.MultipartRequestParser;
import org.richfaces.request.MultipartRequestSizeExceeded;
import org.richfaces.request.ProgressControl;

public class FileUploadFacesContextFactory
extends FacesContextFactory
implements FacesWrapper<FacesContextFactory> {
    public static final String UID_KEY = "rf_fu_uid";
    private static final Logger LOGGER = RichfacesLogger.CONTEXT.getLogger();
    private static final Pattern AMPERSAND = Pattern.compile("&+");
    private FacesContextFactory wrappedFactory;

    public FileUploadFacesContextFactory(FacesContextFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
    }

    public FacesContextFactory getWrapped() {
        return this.wrappedFactory;
    }

    private String getParameterValueFromQueryString(String queryString, String paramName) {
        if (queryString != null) {
            String[] nvPairs;
            for (String nvPair : nvPairs = AMPERSAND.split(queryString)) {
                int eqIdx;
                if (nvPair.length() == 0 || (eqIdx = nvPair.indexOf(61)) < 0) continue;
                try {
                    String name = URLDecoder.decode(nvPair.substring(0, eqIdx), "UTF-8");
                    if (paramName.equals(name)) {
                        return URLDecoder.decode(nvPair.substring(eqIdx + 1), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.debug(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        String uid;
        HttpServletRequest httpRequest;
        if (request instanceof HttpServletRequest && (httpRequest = (HttpServletRequest)request).getContentType() != null && httpRequest.getContentType().startsWith("multipart/") && (uid = this.getParameterValueFromQueryString(httpRequest.getQueryString(), UID_KEY)) != null) {
            long contentLength = Long.parseLong(httpRequest.getHeader("Content-Length"));
            ProgressControl progressControl = new ProgressControl(uid, contentLength);
            HttpServletRequest wrappedRequest = ServletVersion.getCurrent().isCompliantWith(ServletVersion.SERVLET_3_0) ? this.wrapMultipartRequestServlet30((ServletContext)context, httpRequest, uid, contentLength, progressControl) : this.wrapMultipartRequestServlet25((ServletContext)context, httpRequest, uid, contentLength, progressControl);
            FacesContext facesContext = this.wrappedFactory.getFacesContext(context, (Object)wrappedRequest, response, lifecycle);
            progressControl.setContextMap(facesContext.getExternalContext().getSessionMap());
            return new FileUploadFacesContext(facesContext);
        }
        return this.wrappedFactory.getFacesContext(context, request, response, lifecycle);
    }

    private boolean isCreateTempFiles(ServletContext servletContext) {
        String param = servletContext.getInitParameter("org.richfaces.fileUpload.createTempFiles");
        if (param != null) {
            return Boolean.parseBoolean(param);
        }
        return true;
    }

    private String getTempFilesDirectory(ServletContext servletContext) {
        File servletTempDir;
        String result = servletContext.getInitParameter("org.richfaces.fileUpload.tempFilesDirectory");
        if (result == null && (servletTempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir")) != null) {
            result = servletTempDir.getAbsolutePath();
        }
        if (result == null) {
            result = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        }
        return result;
    }

    private long getMaxRequestSize(ServletContext servletContext) {
        String param = servletContext.getInitParameter("org.richfaces.fileUpload.maxRequestSize");
        if (param != null) {
            return Long.parseLong(param);
        }
        return 0L;
    }

    private HttpServletRequest wrapMultipartRequestServlet25(ServletContext servletContext, HttpServletRequest request, String uploadId, long contentLength, ProgressControl progressControl) {
        BaseMultipartRequest multipartRequest;
        long maxRequestSize = this.getMaxRequestSize(servletContext);
        if (maxRequestSize == 0L || contentLength <= maxRequestSize) {
            boolean createTempFiles = this.isCreateTempFiles(servletContext);
            String tempFilesDirectory = this.getTempFilesDirectory(servletContext);
            MultipartRequestParser requestParser = new MultipartRequestParser(request, createTempFiles, tempFilesDirectory, progressControl);
            multipartRequest = new MultipartRequest25(request, uploadId, progressControl, requestParser);
        } else {
            multipartRequest = new MultipartRequestSizeExceeded(request, uploadId, progressControl);
        }
        request.setAttribute(MultipartRequest.REQUEST_ATTRIBUTE_NAME, (Object)multipartRequest);
        return multipartRequest;
    }

    private HttpServletRequest wrapMultipartRequestServlet30(ServletContext servletContext, HttpServletRequest request, String uploadId, long contentLength, ProgressControl progressControl) {
        long maxRequestSize = this.getMaxRequestSize(servletContext);
        BaseMultipartRequest multipartRequest = maxRequestSize == 0L || contentLength <= maxRequestSize ? new MultipartRequest30(request, uploadId, progressControl) : new MultipartRequestSizeExceeded(request, uploadId, progressControl);
        request.setAttribute(MultipartRequest.REQUEST_ATTRIBUTE_NAME, (Object)multipartRequest);
        return multipartRequest;
    }

    private static final class FileUploadFacesContext
    extends FacesContextWrapper {
        private FacesContext facesContext;

        public FileUploadFacesContext(FacesContext facesContext) {
            this.facesContext = facesContext;
        }

        public FacesContext getWrapped() {
            return this.facesContext;
        }

        public void release() {
            MultipartRequest multipartRequest = (MultipartRequest)this.getExternalContext().getRequestMap().get(MultipartRequest.REQUEST_ATTRIBUTE_NAME);
            if (multipartRequest != null) {
                multipartRequest.release();
            }
            super.release();
        }
    }
}

