/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fileUpload;

import java.io.IOException;
import java.io.Writer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.request.MultipartRequest;

public class FileUploadPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -3130357236442351405L;
    private static final Logger LOGGER = RichfacesLogger.CONTEXT.getLogger();

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        MultipartRequest multipartRequest = (MultipartRequest)event.getFacesContext().getExternalContext().getRequestMap().get(MultipartRequest.REQUEST_ATTRIBUTE_NAME);
        if (multipartRequest != null && multipartRequest.getResponseState() != MultipartRequest.ResponseState.ok) {
            this.printResponse(event.getFacesContext(), multipartRequest);
        }
    }

    private void printResponse(FacesContext facesContext, MultipartRequest multipartRequest) {
        facesContext.responseComplete();
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.setResponseStatus(200);
        externalContext.setResponseContentType("text/html");
        try {
            Writer writer = externalContext.getResponseOutputWriter();
            writer.write("<html id=\"rf_fu_uid" + multipartRequest.getUploadId() + ":" + (Object)((Object)multipartRequest.getResponseState()) + "\"/>");
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

