/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.richfaces.javascript.ScriptString;
import org.richfaces.javascript.ScriptStringBase;
import org.richfaces.javascript.ScriptUtils;

public class JSFunction
extends ScriptStringBase
implements ScriptString {
    private List<Object> parameters = new ArrayList<Object>();
    private String name;

    public JSFunction(String name, Object ... parameters) {
        this.name = name;
        this.parameters.addAll(Arrays.asList(parameters));
    }

    public JSFunction addParameter(Object parameter) {
        this.getParameters().add(parameter);
        return this;
    }

    @Override
    public void appendScript(Appendable target) throws IOException {
        target.append(this.name).append('(');
        boolean first = true;
        List<Object> parameters = this.getParameters();
        if (null != parameters) {
            for (Object element : parameters) {
                if (!first) {
                    target.append(',');
                }
                if (null != element) {
                    ScriptUtils.appendScript(target, element);
                } else {
                    target.append("null");
                }
                first = false;
            }
        }
        target.append(")");
    }

    public List<Object> getParameters() {
        return this.parameters;
    }
}

